/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.pnbinom;
import org.renjin.nmath.qnorm;
import org.renjin.nmath.qpois;

public class qnbinom {
    private qnbinom() {
    }

    public static double qnbinom_mu(double d, double d2, double d3, int n, int n2) {
        double d4;
        double d5 = 1.0 / 0.0;
        if (d2 == d5) {
            d4 = qpois.qpois(d, d3, n, n2);
        } else {
            double d6 = d2 + d3;
            double d7 = d2 / d6;
            d4 = qnbinom.qnbinom(d, d2, d7, n, n2);
        }
        return d4;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double qnbinom(double d, double d2, double d3, int n, int n2) {
        double oldincr;
        double z$17;
        double z$13;
        double[] z = new double[]{0.0};
        if (Builtins.__isnan(d) != 0) return d + d2 + d3;
        if (Builtins.__isnan(d2) != 0) return d + d2 + d3;
        if (Builtins.__isnan(d3) != 0) return d + d2 + d3;
        if (d3 == 0.0) {
            if (d2 == 0.0) return 0.0;
        }
        if (d3 <= 0.0) return 0.0 / 0.0;
        if (d3 > 1.0) return 0.0 / 0.0;
        if (d2 < 0.0) return 0.0 / 0.0;
        if (d3 == 1.0) return 0.0;
        if (d2 == 0.0) return 0.0;
        if (n2 != 0) {
            if (d > 0.0) return 0.0 / 0.0;
            if (d == 0.0) {
                if (n == 0) {
                    return 0.0;
                }
                double iftmp$0 = 1.0 / 0.0;
                return iftmp$0;
            }
            double d4 = -1.0 / 0.0;
            if (d == d4) {
                if (n != 0) {
                    return 0.0;
                }
                double iftmp$1 = 1.0 / 0.0;
                return iftmp$1;
            }
        } else {
            if (d < 0.0) return 0.0 / 0.0;
            if (d > 1.0) return 0.0 / 0.0;
            if (d == 0.0) {
                if (n != 0) {
                    return 0.0;
                }
                double iftmp$2 = 1.0 / 0.0;
                return iftmp$2;
            }
            if (d == 1.0) {
                if (n == 0) {
                    return 0.0;
                }
                double iftmp$3 = 1.0 / 0.0;
                return iftmp$3;
            }
        }
        double Q = 1.0 / d3;
        double P = (1.0 - d3) * Q;
        double mu = d2 * P;
        double sigma = Mathlib.sqrt(d2 * P * Q);
        double gamma2 = (Q + P) / sigma;
        if (n == 0 || n2 != 0) {
            double iftmp$10;
            double iftmp$7;
            double iftmp$4;
            if (n2 != 0) {
                double iftmp$5 = n != 0 ? Math.exp(d) : -Mathlib.expm1(d);
                iftmp$4 = iftmp$5;
            } else {
                double iftmp$6 = n == 0 ? 0.5 - d + 0.5 : d;
                iftmp$4 = iftmp$6;
            }
            d = iftmp$4;
            if (n != 0) {
                double iftmp$8 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$7 = iftmp$8;
            } else {
                double iftmp$9 = n2 != 0 ? 0.0 : 1.0;
                iftmp$7 = iftmp$9;
            }
            if (iftmp$7 == d) return 0.0;
            if (n != 0) {
                double iftmp$11 = n2 != 0 ? 0.0 : 1.0;
                iftmp$10 = iftmp$11;
            } else {
                double iftmp$12 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$10 = iftmp$12;
            }
            if (iftmp$10 == d) return 1.0 / 0.0;
        }
        if (d + 2.242650509742816E-16 >= 1.0) return 1.0 / 0.0;
        z[0] = z$13 = qnorm.qnorm5(d, 0.0, 1.0, 1, 0);
        double z$14 = z[0];
        double z$15 = z[0];
        double d5 = (z$14 * z$15 - 1.0) * gamma2 / 6.0;
        double z$16 = z[0];
        double y = Mathlib.round((d5 + z$16) * sigma + mu);
        z[0] = z$17 = pnbinom.pnbinom(y, d2, d3, 1, 0);
        d *= 0.9999999999999858;
        if (y < 100000.0) return qnbinom.do_search(y, new DoublePtr(z, 0), d, d2, d3, 1.0);
        double incr = Mathlib.floor(y * 0.001);
        do {
            oldincr = incr;
            y = qnbinom.do_search(y, new DoublePtr(z, 0), d, d2, d3, incr);
            double d6 = Mathlib.floor(incr / 100.0);
            incr = fmax2.fmax2(1.0, d6);
        } while (oldincr > 1.0 && y * 1.0E-15 < incr);
        return y;
    }

    public static double do_search(double d, DoublePtr doublePtr, double d2, double d3, double d4, double d5) {
        double d6;
        block3: {
            int z$offset;
            double[] z$array;
            block4: {
                z$array = doublePtr.array;
                z$offset = doublePtr.offset;
                if (!(z$array[z$offset] >= d2)) break block4;
                while (true) {
                    block6: {
                        block5: {
                            double d7;
                            if (d == 0.0) break block5;
                            z$array[z$offset] = d7 = pnbinom.pnbinom(d - d5, d3, d4, 1, 0);
                            if (!(z$array[z$offset] < d2)) break block6;
                        }
                        d6 = d;
                        break block3;
                    }
                    double d8 = d - d5;
                    d = fmax2.fmax2(0.0, d8);
                }
            }
            do {
                double d9;
                z$array[z$offset] = d9 = pnbinom.pnbinom(d += d5, d3, d4, 1, 0);
            } while (!(z$array[z$offset] >= d2));
            d6 = d;
        }
        return d6;
    }
}

