/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.Builtins;
import org.renjin.nmath.rchisq;
import org.renjin.nmath.rgamma;
import org.renjin.nmath.rpois;

public class rnchisq {
    private rnchisq() {
    }

    public static double rnchisq(MethodHandle methodHandle, double d, double d2) {
        double d3;
        if (Builtins.__finite(d) == 0 || Builtins.__finite(d2) == 0 || d < 0.0 || d2 < 0.0) {
            d3 = 0.0 / 0.0;
        } else if (d2 == 0.0) {
            double iftmp$0;
            if (d != 0.0) {
                double d4 = d / 2.0;
                iftmp$0 = rgamma.rgamma(methodHandle, d4, 2.0);
            } else {
                iftmp$0 = 0.0;
            }
            d3 = iftmp$0;
        } else {
            double d5 = d2 / 2.0;
            double r = rpois.rpois(methodHandle, d5);
            if (r > 0.0) {
                double d6 = r * 2.0;
                r = rchisq.rchisq(methodHandle, d6);
            }
            if (d > 0.0) {
                double d7 = d / 2.0;
                r = rgamma.rgamma(methodHandle, d7, 2.0) + r;
            }
            d3 = r;
        }
        return d3;
    }
}

