/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine.view;

import org.renjin.primitives.vector.DeferredComputation;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class CombinedDoubleVector
extends DoubleVector
implements DeferredComputation {
    private final Vector[] vectors;
    private final int[] endIndex;
    private final int totalLength;

    public static DoubleVector combine(Vector[] vectors, AttributeMap attributeMap) {
        if (vectors.length == 1) {
            return (DoubleVector)vectors[0].setAttributes(attributeMap);
        }
        return new CombinedDoubleVector(vectors, attributeMap);
    }

    private CombinedDoubleVector(Vector[] vectors, AttributeMap attributeMap) {
        super(attributeMap);
        this.vectors = vectors;
        this.endIndex = new int[vectors.length];
        int totalLength = 0;
        for (int i = 0; i != vectors.length; ++i) {
            this.endIndex[i] = totalLength += vectors[i].length();
        }
        this.totalLength = totalLength;
    }

    @Override
    public Vector[] getOperands() {
        return this.vectors;
    }

    @Override
    public String getComputationName() {
        return "c";
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new CombinedDoubleVector(this.vectors, attributes2);
    }

    @Override
    public boolean isDeferred() {
        return true;
    }

    @Override
    public double getElementAsDouble(int index) {
        if (index < this.endIndex[0]) {
            return this.vectors[0].getElementAsDouble(index);
        }
        if (index < this.endIndex[1]) {
            return this.vectors[1].getElementAsDouble(index - this.endIndex[0]);
        }
        if (index < this.endIndex[2]) {
            return this.vectors[2].getElementAsDouble(index - this.endIndex[1]);
        }
        if (index < this.endIndex[3]) {
            return this.vectors[3].getElementAsDouble(index - this.endIndex[2]);
        }
        for (int i = 4; i < this.vectors.length; ++i) {
            if (index >= this.endIndex[i]) continue;
            return this.vectors[i].getElementAsDouble(index - this.endIndex[i - 1]);
        }
        throw new IllegalArgumentException("index: " + index);
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public int length() {
        return this.totalLength;
    }
}

