/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.matrix;

import org.renjin.primitives.Indexes;
import org.renjin.primitives.matrix.DoubleMatrixBuilder;
import org.renjin.primitives.matrix.IntMatrixBuilder;
import org.renjin.primitives.matrix.MatrixBuilder;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.Symbols;
import org.renjin.sexp.Vector;

public class Matrix {
    private final Vector vector;
    private final int nrows;
    private final int ncols;

    public Matrix(Vector vector2) {
        Vector dim2 = (Vector)vector2.getAttribute(Symbols.DIM);
        if (dim2.length() != 2) {
            throw new IllegalArgumentException("vector is not a matrix");
        }
        this.vector = vector2;
        this.nrows = dim2.getElementAsInt(0);
        this.ncols = dim2.getElementAsInt(1);
    }

    public Matrix(Vector vector2, int ncols) {
        this.vector = vector2;
        this.ncols = ncols;
        this.nrows = vector2.length() / ncols;
    }

    public Vector getVector() {
        return this.vector;
    }

    public int getNumRows() {
        return this.nrows;
    }

    public int getNumCols() {
        return this.ncols;
    }

    public Vector getRowNames() {
        return this.getDimNames(0);
    }

    public Vector getColNames() {
        return this.getDimNames(1);
    }

    public String getRowName(int rowIndex) {
        Vector rowNames = this.getRowNames();
        if (rowNames == Null.INSTANCE) {
            return null;
        }
        return rowNames.getElementAsString(rowIndex);
    }

    public String getColName(int colIndex) {
        Vector rowNames = this.getColNames();
        if (rowNames == Null.INSTANCE) {
            return null;
        }
        return rowNames.getElementAsString(colIndex);
    }

    private Vector getDimNames(int dimensionIndex) {
        Vector dimNames = (Vector)this.vector.getAttribute(Symbols.DIMNAMES);
        if (dimNames.length() != 2) {
            return Null.INSTANCE;
        }
        return (Vector)dimNames.getElementAsSEXP(dimensionIndex);
    }

    private int computeIndex(int row2, int col2) {
        return Indexes.matrixIndexToVectorIndex(row2, col2, this.nrows, this.ncols);
    }

    public int getElementAsInt(int row2, int col2) {
        return this.vector.getElementAsInt(this.computeIndex(row2, col2));
    }

    public double getElementAsDouble(int row2, int col2) {
        return this.vector.getElementAsDouble(this.computeIndex(row2, col2));
    }

    public MatrixBuilder newBuilder(int rows, int cols) {
        if (this.vector instanceof IntVector) {
            return new IntMatrixBuilder(rows, cols);
        }
        if (this.vector instanceof DoubleVector) {
            return new DoubleMatrixBuilder(rows, cols);
        }
        throw new UnsupportedOperationException("unimplemented type " + this.vector.getTypeName());
    }
}

