/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.sequence;

import org.renjin.primitives.sequence.RepDoubleVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

public class RepIntVector
extends IntVector {
    public static final int LENGTH_THRESHOLD = 100;
    private final Vector source;
    private int length;
    private int each;

    public RepIntVector(Vector source, int length2, int each, AttributeMap attributes2) {
        super(attributes2);
        this.source = source;
        this.length = length2;
        this.each = each;
        if (this.length <= 0) {
            throw new IllegalArgumentException("length: " + length2);
        }
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new RepDoubleVector(this.source, this.length, this.each, attributes2);
    }

    @Override
    public int getElementAsInt(int index) {
        return this.source.getElementAsInt(index / this.each % this.source.length());
    }

    @Override
    public boolean isConstantAccessTime() {
        return true;
    }

    @Override
    public int length() {
        return this.length;
    }
}

