/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.sequence;

import org.apache.commons.math.linear.RealVector;
import org.renjin.eval.Calls;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.Internal;
import org.renjin.primitives.Warning;
import org.renjin.primitives.sequence.DoubleSequence;
import org.renjin.primitives.sequence.IntSequence;
import org.renjin.repackaged.guava.annotations.VisibleForTesting;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class Sequences {
    @Builtin(value=":")
    public static AtomicVector colon(@Current Context context, SEXP n1, SEXP n2) {
        if (n1.inherits("factor") && n2.inherits("factor")) {
            return Sequences.crossColon(n1, n2);
        }
        return Sequences.colonSequence(context, n1, n2);
    }

    private static AtomicVector crossColon(SEXP n1, SEXP n2) {
        throw new UnsupportedOperationException("crossColon not yet implemented");
    }

    public static AtomicVector colonSequence(Context context, SEXP s1, SEXP s2) {
        Sequences.assertScalar(context, s1);
        Sequences.assertScalar(context, s2);
        double n1 = s1.asReal();
        double n2 = s2.asReal();
        Sequences.assertNotNa(n1);
        Sequences.assertNotNa(n2);
        return new Range(n1, n2).vector();
    }

    private static void assertNotNa(double r1) {
        if (DoubleVector.isNaN(r1)) {
            throw new EvalException("NA/NaN argument", new Object[0]);
        }
    }

    private static void assertScalar(Context context, SEXP exp2) {
        if (exp2.length() == 0) {
            throw new EvalException("argument of length 0", new Object[0]);
        }
        if (exp2.length() > 1) {
            Warning.invokeWarning(context, "numerical expression has %d elements: only the first used", exp2.length());
        }
    }

    private static void assertFinite(String name, double to) {
        if (!DoubleVector.isFinite(to)) {
            throw new EvalException("'" + name + "' must be finite", new Object[0]);
        }
    }

    @Internal(value="rep.int")
    public static Vector repeatInt(Vector x, Vector timesVector) {
        if (timesVector.length() == 1) {
            int times2;
            Vector.Builder result = x.newBuilderWithInitialSize(x.length() * times2);
            int count = 0;
            for (times2 = timesVector.getElementAsInt(0); times2 > 0; --times2) {
                for (int i = 0; i != x.length(); ++i) {
                    result.setFrom(count++, x, i);
                }
            }
            return result.build();
        }
        if (timesVector.length() != x.length()) {
            throw new EvalException("Invalid 'times' value: times must be the same length as x", new Object[0]);
        }
        Vector.Builder result = x.newBuilderWithInitialCapacity(x.length());
        for (int i = 0; i != x.length(); ++i) {
            for (int times3 = timesVector.getElementAsInt(i); times3 > 0; --times3) {
                result.addFrom(x, i);
            }
        }
        return result.build();
    }

    @Builtin(value="seq.int")
    public static SEXP seqInt(@Current Context context, @Current Environment rho, @ArgumentList ListVector argList) {
        PairList args2 = new PairList.Builder().addAll(argList).build();
        PairList.Builder formals2 = new PairList.Builder();
        formals2.add("from", (SEXP)Symbol.MISSING_ARG);
        formals2.add("to", (SEXP)Symbol.MISSING_ARG);
        formals2.add("by", (SEXP)Symbol.MISSING_ARG);
        formals2.add("length.out", (SEXP)Symbol.MISSING_ARG);
        formals2.add("along.with", (SEXP)Symbol.MISSING_ARG);
        boolean One = args2.length() == 1;
        PairList matched = Calls.matchArguments(formals2.build(), args2, true);
        SEXP from = matched.findByTag(Symbol.get("from"));
        SEXP to = matched.findByTag(Symbol.get("to"));
        SEXP by = matched.findByTag(Symbol.get("by"));
        SEXP len = matched.findByTag(Symbol.get("length.out"));
        SEXP along = matched.findByTag(Symbol.get("along.with"));
        if (from != Symbol.MISSING_ARG) {
            from = context.evaluate(from, rho);
        }
        if (to != Symbol.MISSING_ARG) {
            to = context.evaluate(to, rho);
        }
        if (by != Symbol.MISSING_ARG) {
            by = context.evaluate(by, rho);
        }
        if (len != Symbol.MISSING_ARG) {
            len = context.evaluate(len, rho);
        }
        return Sequences.doSeqInt(from, to, by, len, along, One);
    }

    private static SEXP doSeqInt(SEXP from, SEXP to, SEXP by, SEXP len, SEXP along, boolean one) {
        double rfrom;
        if (one && from != Symbol.MISSING_ARG) {
            int lf = from.length();
            if (lf == 1 && (from instanceof IntVector || from instanceof RealVector)) {
                return new Range(1.0, ((AtomicVector)from).getElementAsDouble(0)).vector();
            }
            if (lf != 0) {
                return new Range(1.0, lf).vector();
            }
            return new IntArrayVector(new int[0]);
        }
        int lout = Integer.MIN_VALUE;
        if (along != Symbol.MISSING_ARG) {
            if (one) {
                throw new UnsupportedOperationException("implement me!");
            }
        } else if (len != Symbol.MISSING_ARG && len != Symbol.MISSING_ARG) {
            double rout = len.asReal();
            if (Double.isNaN(rout) || rout <= -0.5) {
                throw new EvalException("'length.out' must be a non-negative number", new Object[0]);
            }
            lout = (int)Math.ceil(rout);
        }
        if (IntVector.isNA(lout)) {
            rfrom = from == Symbol.MISSING_ARG ? 1.0 : from.asReal();
            double rto = to == Symbol.MISSING_ARG ? 1.0 : to.asReal();
            double rby = by.asReal();
            if (by == Symbol.MISSING_ARG) {
                return new Range(rfrom, rto).vector();
            }
            return Sequences.sequenceBy(from, to, rfrom, rto, rby);
        }
        if (lout == 0) {
            return new IntArrayVector(new int[0]);
        }
        if (one) {
            return new Range(1.0, lout).vector();
        }
        if (by == Symbol.MISSING_ARG) {
            rfrom = from.asReal();
            double rto = to.asReal();
            if (to == Symbol.MISSING_ARG) {
                rto = rfrom + (double)lout - 1.0;
            }
            if (from == Symbol.MISSING_ARG) {
                rfrom = rto - (double)lout + 1.0;
            }
            return Sequences.sequenceFromTo(rfrom, rto, lout);
        }
        if (to == Symbol.MISSING_ARG) {
            rfrom = from == Symbol.MISSING_ARG ? 1.0 : from.asReal();
            return Sequences.sequenceFrom(lout, rfrom, by.asReal());
        }
        if (from == Symbol.MISSING_ARG) {
            return Sequences.sequenceTo(lout, to.asReal(), by.asReal());
        }
        throw new EvalException("too many arguments", new Object[0]);
    }

    private static SEXP sequenceBy(SEXP from, SEXP to, double rfrom, double rto, double by) {
        double del = rto - rfrom;
        if (!DoubleVector.isFinite(rfrom)) {
            throw new EvalException("'from' must be finite", new Object[0]);
        }
        Sequences.assertFinite("to", rto);
        if (del == 0.0 && rto == 0.0) {
            return to;
        }
        double n = del / by;
        if (!DoubleVector.isFinite(n)) {
            if (del == 0.0 && by == 0.0) {
                return from;
            }
            throw new EvalException("invalid '(to - from)/by' in 'seq'", new Object[0]);
        }
        double dd = Math.abs(del) / Math.max(Math.abs(rto), Math.abs(rfrom));
        if (dd < 2.2204459999999998E-14) {
            return from;
        }
        if (n > 2.147483647E9) {
            throw new EvalException("'by' argument is much too small", new Object[0]);
        }
        if (n < -2.220446E-16) {
            throw new EvalException("wrong sign in 'by' argument", new Object[0]);
        }
        int nn = (int)(n + 2.220446E-16);
        double[] ra = new double[nn + 1];
        for (int i = 0; i <= nn; ++i) {
            ra[i] = rfrom + (double)i * by;
        }
        if (nn > 0 && (by > 0.0 && ra[nn] > rto || by < 0.0 && ra[nn] < rto)) {
            ra[nn] = rto;
        }
        return new DoubleArrayVector(ra);
    }

    private static SEXP sequenceFromTo(double from, double to, int length2) {
        Sequences.assertFinite("from", from);
        Sequences.assertFinite("to", to);
        if (length2 == 1) {
            return Sequences.newSequence(from, 1.0, to, length2);
        }
        double by = (to - from) / (double)(length2 - 1);
        return Sequences.newSequence(from, by, to, length2);
    }

    private static SEXP sequenceTo(int length2, double to, double by) {
        Sequences.assertFinite("to", to);
        Sequences.assertFinite("by", by);
        double from = to - (double)(length2 - 1) * by;
        return Sequences.newSequence(from, by, to, length2);
    }

    private static SEXP sequenceFrom(int length2, double from, double by) {
        Sequences.assertFinite("from", from);
        Sequences.assertFinite("by", by);
        double to = from + (double)(length2 - 1) * by;
        return Sequences.newSequence(from, by, to, length2);
    }

    @Builtin
    public static IntVector seq_along(SEXP exp2) {
        return new IntSequence(1, 1, exp2.length());
    }

    @Builtin
    public static IntVector seq_len(int length2) {
        return new IntSequence(1, 1, length2);
    }

    private static SEXP newSequence(double from, double by, double to, int length2) {
        if (Sequences.isIntegerRange(from, to, by)) {
            return new IntSequence((int)from, (int)by, length2);
        }
        return new DoubleSequence(from, by, length2);
    }

    private static boolean isIntegerRange(double from, double to, double by) {
        return by == (double)((int)by) && from <= 2.147483647E9 && from >= -2.147483648E9 && to <= 2.147483647E9 && to >= -2.147483648E9;
    }

    @VisibleForTesting
    static class Range {
        boolean useInteger;
        private double range;
        double count;
        final double n1;
        final double n2;

        public Range(double n1, double n2) {
            this.n1 = n1;
            this.n2 = n2;
            this.range = Math.abs(n2 - n1);
            this.count = this.range + 1.0 + 2.220446E-16;
            this.determineType();
        }

        private void determineType() {
            int in1 = (int)this.n1;
            boolean bl = this.useInteger = this.n1 == (double)in1;
            if (this.useInteger) {
                if (this.n1 <= -2.147483648E9 || this.n1 > 2.147483647E9) {
                    this.useInteger = false;
                } else {
                    double upperBound = this.n1 + (this.n1 <= this.n2 ? this.count - 1.0 : -(this.count - 1.0));
                    if (upperBound <= -2.147483648E9 || upperBound > 2.147483647E9) {
                        this.useInteger = false;
                    }
                }
            }
        }

        public AtomicVector vector() {
            if (this.useInteger) {
                return IntSequence.fromTo(this.n1, this.n2);
            }
            return DoubleSequence.fromTo(this.n1, this.n2);
        }
    }
}

