/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.special;

import org.renjin.compiler.CompiledLoopBody;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.TypeSolver;
import org.renjin.compiler.cfg.ControlFlowGraph;
import org.renjin.compiler.cfg.DominanceTree;
import org.renjin.compiler.cfg.UseDefMap;
import org.renjin.compiler.codegen.ByteCodeEmitter;
import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.compiler.ir.ssa.SsaTransformer;
import org.renjin.compiler.ir.tac.IRBody;
import org.renjin.compiler.ir.tac.IRBodyBuilder;
import org.renjin.compiler.ir.tac.RuntimeState;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.eval.Profiler;
import org.renjin.primitives.Deparse;
import org.renjin.primitives.special.BreakException;
import org.renjin.primitives.special.NextException;
import org.renjin.sexp.Environment;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public class ForFunction
extends SpecialFunction {
    public static boolean COMPILE_LOOPS = Boolean.getBoolean("renjin.compile.loops");
    private static final int COMPILE_THRESHOLD = 200;
    private static final int WARMUP_ITERATIONS = 5;

    public ForFunction() {
        super("for");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SEXP apply(Context context, Environment rho, FunctionCall call2, PairList _args_unused) {
        boolean profiling;
        PairList args2 = call2.getArguments();
        Symbol symbol2 = (Symbol)args2.getElementAsSEXP(0);
        SEXP elementsExp = context.evaluate((SEXP)args2.getElementAsSEXP(1), rho);
        if (!(elementsExp instanceof Vector)) {
            throw new EvalException("invalid for() loop sequence", new Object[0]);
        }
        Vector elements = (Vector)elementsExp;
        Object statement = args2.getElementAsSEXP(2);
        boolean bl = profiling = Profiler.ENABLED && elements.length() > 200;
        if (profiling) {
            Profiler.loopStart(call2, elements);
        }
        int i = 0;
        try {
            boolean compilationFailed = false;
            for (i = 0; i != elements.length(); ++i) {
                try {
                    if (COMPILE_LOOPS && i >= 5 && elements.length() > 200 && !compilationFailed) {
                        if (this.tryCompileAndRun(context, rho, call2, elements, i)) {
                            break;
                        }
                        compilationFailed = true;
                    }
                    rho.setVariable(symbol2, (SEXP)elements.getElementAsSEXP(i));
                    context.evaluate((SEXP)statement, rho);
                    continue;
                }
                catch (BreakException e) {
                    break;
                }
                catch (NextException nextException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (profiling) {
                Profiler.loopEnd(i);
            }
        }
        context.setInvisibleFlag();
        return Null.INSTANCE;
    }

    private boolean tryCompileAndRun(Context context, Environment rho, FunctionCall call2, Vector elements, int i) {
        CompiledLoopBody compiledBody = null;
        try {
            RuntimeState runtimeState = new RuntimeState(context, rho);
            IRBodyBuilder builder = new IRBodyBuilder(runtimeState);
            IRBody body2 = builder.buildLoopBody(call2, elements);
            ControlFlowGraph cfg = new ControlFlowGraph(body2);
            DominanceTree dTree = new DominanceTree(cfg);
            SsaTransformer ssaTransformer = new SsaTransformer(cfg, dTree);
            ssaTransformer.transform();
            UseDefMap useDefMap = new UseDefMap(cfg);
            TypeSolver types = new TypeSolver(cfg, useDefMap);
            types.execute();
            types.verifyFunctionAssumptions(runtimeState);
            ssaTransformer.removePhiFunctions(types);
            ByteCodeEmitter emitter = new ByteCodeEmitter(cfg, types);
            compiledBody = emitter.compileLoopBody().newInstance();
        }
        catch (NotCompilableException e) {
            context.warn("Could not compile loop with %d iterations because: " + this.format(context, e));
            return false;
        }
        catch (InvalidSyntaxException e) {
            throw new EvalException(e.getMessage(), new Object[0]);
        }
        catch (Exception e) {
            throw new EvalException("Exception compiling loop: " + e.getMessage(), e);
        }
        compiledBody.run(context, rho, elements, i);
        return true;
    }

    private String format(Context context, NotCompilableException e) {
        StringBuilder s = new StringBuilder();
        while (e != null) {
            if (s.length() > 0) {
                s.append(" > ");
            }
            if (e.getSexp() != null) {
                s.append(Deparse.deparseExp(context, e.getSexp()));
            }
            if (e.getMessage() != null) {
                s.append(": ").append(e.getMessage());
            }
            e = e.getCause();
        }
        return s.toString();
    }
}

