/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.subset;

import org.renjin.primitives.vector.MemoizedComputation;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

class MaskedDoubleReplacement
extends DoubleVector
implements MemoizedComputation {
    private AtomicVector source;
    private LogicalVector mask;
    private AtomicVector replacement;
    private DoubleVector result = null;

    public MaskedDoubleReplacement(AttributeMap attributes2, AtomicVector source, LogicalVector mask, AtomicVector replacement) {
        super(attributes2);
        this.source = source;
        this.mask = mask;
        this.replacement = replacement;
    }

    @Override
    public Vector[] getOperands() {
        return new Vector[]{this.source, this.mask, this.replacement};
    }

    @Override
    public String getComputationName() {
        return "[[<-";
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new MaskedDoubleReplacement(attributes2, this.source, this.mask, this.replacement);
    }

    @Override
    public double getElementAsDouble(int index) {
        if (this.result == null) {
            throw new IllegalStateException("Not computed");
        }
        return this.result.getElementAsDouble(index);
    }

    @Override
    public boolean isConstantAccessTime() {
        return false;
    }

    @Override
    public int length() {
        return this.source.length();
    }

    @Override
    public Vector forceResult() {
        int resultLength = Math.max(this.mask.length(), this.source.length());
        DoubleArrayVector.Builder result = new DoubleArrayVector.Builder(resultLength, resultLength);
        int maskLength = this.mask.length();
        int replacementLength = this.replacement.length();
        int replacementIndex = 0;
        for (int i = 0; i < resultLength; ++i) {
            int maskValue = this.mask.getElementAsRawLogical(i % maskLength);
            if (maskValue == 1) {
                result.set(i, this.replacement.getElementAsDouble(replacementIndex++ % replacementLength));
                continue;
            }
            if (i >= this.source.length()) continue;
            result.set(i, this.source.getElementAsDouble(i));
        }
        this.result = result.build();
        return this.result;
    }

    @Override
    public void setResult(Vector result) {
        this.result = (DoubleVector)result;
    }

    @Override
    public boolean isCalculated() {
        return this.result != null;
    }
}

