/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.text.regex;

public class FuzzyMatcher {
    private final String pattern;
    private final boolean ignoreCase;

    public FuzzyMatcher(String pattern, boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
        this.pattern = ignoreCase ? pattern.toLowerCase() : pattern;
    }

    public int contains(String source) {
        int y;
        int x;
        int m = this.pattern.length() + 1;
        int n = source.length() + 1;
        if (this.ignoreCase) {
            source = source.toLowerCase();
        }
        int[][] e = new int[this.pattern.length() + 1][source.length() + 1];
        EditType[][] w = new EditType[this.pattern.length() + 1][source.length() + 1];
        for (x = 0; x < n; ++x) {
            e[0][x] = 0;
        }
        char p = '\u0000';
        for (y = 1; y < m; ++y) {
            e[y][0] = y;
            w[y][0] = EditType.DELETE;
            char p1 = p;
            p = this.pattern.charAt(y - 1);
            char s = '\u0000';
            for (int x2 = 1; x2 < n; ++x2) {
                char s1 = s;
                s = source.charAt(x2 - 1);
                int cost = p == s ? 0 : 1;
                int val = e[y - 1][x2 - 1] + cost;
                w[y][x2] = EditType.SUBST;
                int temp = e[y - 1][x2] + 1;
                if (val > temp) {
                    val = temp;
                    w[y][x2] = EditType.DELETE;
                }
                if (val > (temp = e[y][x2 - 1] + 1)) {
                    val = temp;
                    w[y][x2] = EditType.INSERT;
                }
                if (p1 == s && p == s1 && val > (temp = e[y - 2][x2 - 2] + cost)) {
                    val = temp;
                    w[y][x2] = EditType.SWAP;
                }
                e[y][x2] = val;
            }
        }
        int best = n - 1;
        for (x = 0; x < n; ++x) {
            if (e[m - 1][x] >= e[m - 1][best]) continue;
            best = x;
        }
        int start = best;
        y = m - 1;
        block9: while (y > 0) {
            switch (w[y][start]) {
                case INSERT: {
                    --start;
                    continue block9;
                }
                case DELETE: {
                    --y;
                    continue block9;
                }
                case SWAP: {
                    y -= 2;
                    start -= 2;
                    continue block9;
                }
            }
            --start;
            --y;
        }
        return e[m - 1][best];
    }

    private static enum EditType {
        TRANSIT,
        INSERT,
        DELETE,
        SUBST,
        SWAP;

    }
}

