/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.repackaged.guava.primitives;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.Nullable;
import org.renjin.repackaged.guava.annotations.Beta;
import org.renjin.repackaged.guava.annotations.GwtCompatible;
import org.renjin.repackaged.guava.annotations.GwtIncompatible;
import org.renjin.repackaged.guava.base.Converter;
import org.renjin.repackaged.guava.base.Preconditions;
import org.renjin.repackaged.guava.primitives.Doubles;

@GwtCompatible(emulated=true)
public final class Floats {
    public static final int BYTES = 4;

    private Floats() {
    }

    public static int hashCode(float value) {
        return Float.valueOf(value).hashCode();
    }

    public static int compare(float a, float b) {
        return Float.compare(a, b);
    }

    public static boolean isFinite(float value) {
        return Float.NEGATIVE_INFINITY < value & value < Float.POSITIVE_INFINITY;
    }

    public static boolean contains(float[] array2, float target) {
        for (float value : array2) {
            if (value != target) continue;
            return true;
        }
        return false;
    }

    public static int indexOf(float[] array2, float target) {
        return Floats.indexOf(array2, target, 0, array2.length);
    }

    private static int indexOf(float[] array2, float target, int start, int end) {
        for (int i = start; i < end; ++i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static int indexOf(float[] array2, float[] target) {
        Preconditions.checkNotNull(array2, "array");
        Preconditions.checkNotNull(target, "target");
        if (target.length == 0) {
            return 0;
        }
        block0: for (int i = 0; i < array2.length - target.length + 1; ++i) {
            for (int j = 0; j < target.length; ++j) {
                if (array2[i + j] != target[j]) continue block0;
            }
            return i;
        }
        return -1;
    }

    public static int lastIndexOf(float[] array2, float target) {
        return Floats.lastIndexOf(array2, target, 0, array2.length);
    }

    private static int lastIndexOf(float[] array2, float target, int start, int end) {
        for (int i = end - 1; i >= start; --i) {
            if (array2[i] != target) continue;
            return i;
        }
        return -1;
    }

    public static float min(float ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        float min2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            min2 = Math.min(min2, array2[i]);
        }
        return min2;
    }

    public static float max(float ... array2) {
        Preconditions.checkArgument(array2.length > 0);
        float max2 = array2[0];
        for (int i = 1; i < array2.length; ++i) {
            max2 = Math.max(max2, array2[i]);
        }
        return max2;
    }

    public static float[] concat(float[] ... arrays) {
        int length2 = 0;
        for (float[] array2 : arrays) {
            length2 += array2.length;
        }
        float[] result = new float[length2];
        int pos = 0;
        for (float[] array3 : arrays) {
            System.arraycopy(array3, 0, result, pos, array3.length);
            pos += array3.length;
        }
        return result;
    }

    @Beta
    public static Converter<String, Float> stringConverter() {
        return FloatConverter.INSTANCE;
    }

    public static float[] ensureCapacity(float[] array2, int minLength, int padding) {
        Preconditions.checkArgument(minLength >= 0, "Invalid minLength: %s", minLength);
        Preconditions.checkArgument(padding >= 0, "Invalid padding: %s", padding);
        return array2.length < minLength ? Floats.copyOf(array2, minLength + padding) : array2;
    }

    private static float[] copyOf(float[] original, int length2) {
        float[] copy2 = new float[length2];
        System.arraycopy(original, 0, copy2, 0, Math.min(original.length, length2));
        return copy2;
    }

    public static String join(String separator, float ... array2) {
        Preconditions.checkNotNull(separator);
        if (array2.length == 0) {
            return "";
        }
        StringBuilder builder = new StringBuilder(array2.length * 12);
        builder.append(array2[0]);
        for (int i = 1; i < array2.length; ++i) {
            builder.append(separator).append(array2[i]);
        }
        return builder.toString();
    }

    public static Comparator<float[]> lexicographicalComparator() {
        return LexicographicalComparator.INSTANCE;
    }

    public static float[] toArray(Collection<? extends Number> collection) {
        if (collection instanceof FloatArrayAsList) {
            return ((FloatArrayAsList)collection).toFloatArray();
        }
        Object[] boxedArray = collection.toArray();
        int len = boxedArray.length;
        float[] array2 = new float[len];
        for (int i = 0; i < len; ++i) {
            array2[i] = ((Number)Preconditions.checkNotNull(boxedArray[i])).floatValue();
        }
        return array2;
    }

    public static List<Float> asList(float ... backingArray) {
        if (backingArray.length == 0) {
            return Collections.emptyList();
        }
        return new FloatArrayAsList(backingArray);
    }

    @Nullable
    @GwtIncompatible(value="regular expressions")
    @Beta
    public static Float tryParse(String string) {
        if (Doubles.FLOATING_POINT_PATTERN.matcher(string).matches()) {
            try {
                return Float.valueOf(Float.parseFloat(string));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @GwtCompatible
    private static class FloatArrayAsList
    extends AbstractList<Float>
    implements RandomAccess,
    Serializable {
        final float[] array;
        final int start;
        final int end;
        private static final long serialVersionUID = 0L;

        FloatArrayAsList(float[] array2) {
            this(array2, 0, array2.length);
        }

        FloatArrayAsList(float[] array2, int start, int end) {
            this.array = array2;
            this.start = start;
            this.end = end;
        }

        @Override
        public int size() {
            return this.end - this.start;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Float get(int index) {
            Preconditions.checkElementIndex(index, this.size());
            return Float.valueOf(this.array[this.start + index]);
        }

        @Override
        public boolean contains(Object target) {
            return target instanceof Float && Floats.indexOf(this.array, ((Float)target).floatValue(), this.start, this.end) != -1;
        }

        @Override
        public int indexOf(Object target) {
            int i;
            if (target instanceof Float && (i = Floats.indexOf(this.array, ((Float)target).floatValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public int lastIndexOf(Object target) {
            int i;
            if (target instanceof Float && (i = Floats.lastIndexOf(this.array, ((Float)target).floatValue(), this.start, this.end)) >= 0) {
                return i - this.start;
            }
            return -1;
        }

        @Override
        public Float set(int index, Float element) {
            Preconditions.checkElementIndex(index, this.size());
            float oldValue = this.array[this.start + index];
            this.array[this.start + index] = Preconditions.checkNotNull(element).floatValue();
            return Float.valueOf(oldValue);
        }

        @Override
        public List<Float> subList(int fromIndex, int toIndex) {
            int size = this.size();
            Preconditions.checkPositionIndexes(fromIndex, toIndex, size);
            if (fromIndex == toIndex) {
                return Collections.emptyList();
            }
            return new FloatArrayAsList(this.array, this.start + fromIndex, this.start + toIndex);
        }

        @Override
        public boolean equals(Object object2) {
            if (object2 == this) {
                return true;
            }
            if (object2 instanceof FloatArrayAsList) {
                FloatArrayAsList that = (FloatArrayAsList)object2;
                int size = this.size();
                if (that.size() != size) {
                    return false;
                }
                for (int i = 0; i < size; ++i) {
                    if (this.array[this.start + i] == that.array[that.start + i]) continue;
                    return false;
                }
                return true;
            }
            return super.equals(object2);
        }

        @Override
        public int hashCode() {
            int result = 1;
            for (int i = this.start; i < this.end; ++i) {
                result = 31 * result + Floats.hashCode(this.array[i]);
            }
            return result;
        }

        @Override
        public String toString() {
            StringBuilder builder = new StringBuilder(this.size() * 12);
            builder.append('[').append(this.array[this.start]);
            for (int i = this.start + 1; i < this.end; ++i) {
                builder.append(", ").append(this.array[i]);
            }
            return builder.append(']').toString();
        }

        float[] toFloatArray() {
            int size = this.size();
            float[] result = new float[size];
            System.arraycopy(this.array, this.start, result, 0, size);
            return result;
        }
    }

    private static enum LexicographicalComparator implements Comparator<float[]>
    {
        INSTANCE;


        @Override
        public int compare(float[] left, float[] right) {
            int minLength = Math.min(left.length, right.length);
            for (int i = 0; i < minLength; ++i) {
                int result = Floats.compare(left[i], right[i]);
                if (result == 0) continue;
                return result;
            }
            return left.length - right.length;
        }
    }

    private static final class FloatConverter
    extends Converter<String, Float>
    implements Serializable {
        static final FloatConverter INSTANCE = new FloatConverter();
        private static final long serialVersionUID = 1L;

        private FloatConverter() {
        }

        @Override
        protected Float doForward(String value) {
            return Float.valueOf(value);
        }

        @Override
        protected String doBackward(Float value) {
            return value.toString();
        }

        public String toString() {
            return "Floats.stringConverter()";
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }
}

