/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.sexp;

import org.renjin.sexp.AttributeMap;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SexpVisitor;

public class FunctionCall
extends PairList.Node {
    public static final String TYPE_NAME = "language";
    public static final String IMPLICIT_CLASS = "call";

    public FunctionCall(SEXP function2, PairList arguments) {
        super(function2, arguments);
    }

    public FunctionCall(SEXP function2, PairList arguments, AttributeMap attributes2) {
        super(Null.INSTANCE, function2, attributes2, arguments);
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    public static SEXP fromListExp(PairList.Node listExp) {
        return new FunctionCall(listExp.value, listExp.nextNode);
    }

    public SEXP getFunction() {
        return this.value;
    }

    public PairList getArguments() {
        return this.nextNode == null ? Null.INSTANCE : this.nextNode;
    }

    public <X extends SEXP> X getArgument(int index) {
        return (X)this.getArguments().getElementAsSEXP(index);
    }

    @Override
    public void accept(SexpVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getFunction()).append("(");
        boolean needsComma = false;
        for (PairList.Node node : this.getArguments().nodes()) {
            if (needsComma) {
                sb.append(", ");
            } else {
                needsComma = true;
            }
            if (node.hasTag()) {
                sb.append(node.getTag().getPrintName()).append("=");
            }
            sb.append(node.getValue());
        }
        return sb.append(")").toString();
    }

    public static FunctionCall newCall(SEXP function2, SEXP ... arguments) {
        if (arguments.length == 0) {
            return new FunctionCall(function2, Null.INSTANCE);
        }
        return new FunctionCall(function2, PairList.Node.fromArray(arguments));
    }

    public static PairList newCallFromVector(ListVector vector2) {
        Builder call2 = new Builder();
        call2.addAll(vector2);
        return call2.build();
    }

    @Override
    protected SEXP cloneWithNewAttributes(AttributeMap attributes2) {
        return new FunctionCall(this.getFunction(), this.getArguments(), attributes2);
    }

    @Override
    public FunctionCall clone() {
        return new FunctionCall(this.getFunction(), this.getArguments());
    }

    @Override
    public String getImplicitClass() {
        return IMPLICIT_CLASS;
    }

    @Override
    public int hashCode() {
        return this.getFunction().hashCode();
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other.getClass() != FunctionCall.class) {
            return false;
        }
        FunctionCall otherCall = (FunctionCall)other;
        return this.getFunction().equals(otherCall.getFunction()) && this.getArguments().equals(otherCall.getArguments());
    }

    @Override
    public Builder newCopyBuilder() {
        Builder builder = new Builder();
        builder.withAttributes(this.attributes);
        for (PairList.Node node : this.nodes()) {
            builder.add(node.getRawTag(), node.getValue());
        }
        return builder;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public SEXP getNamedArgument(String name) {
        for (PairList.Node node : this.getArguments().nodes()) {
            if (!node.hasTag() || !node.getTag().getPrintName().equals(name)) continue;
            return node.getValue();
        }
        return Null.INSTANCE;
    }

    public static class Builder
    extends PairList.Builder {
        @Override
        public Builder add(SEXP tag, SEXP s) {
            if (this.head == null) {
                this.head = new FunctionCall(s, Null.INSTANCE, this.attributesBuilder.build());
                this.head.setTag(tag);
                this.tail = this.head;
            } else {
                PairList.Node next = new PairList.Node(tag, s, Null.INSTANCE);
                this.tail.nextNode = next;
                this.tail = next;
            }
            return this;
        }
    }
}

