/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.stats.nls;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.DoubleArrayVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Vector;

class NlsModel {
    private final FunctionCall conv;
    private final FunctionCall incr;
    private final FunctionCall deviance;
    private final FunctionCall trace;
    private final Function setPars;
    private final FunctionCall getPars;
    private Context context;

    NlsModel(Context context, ListVector exp2) {
        this.context = context;
        this.conv = NlsModel.getElementAsFunctionCall(exp2, "conv");
        this.incr = NlsModel.getElementAsFunctionCall(exp2, "incr");
        this.deviance = NlsModel.getElementAsFunctionCall(exp2, "deviance");
        this.trace = NlsModel.getElementAsFunctionCall(exp2, "trace");
        this.setPars = NlsModel.getElementAsFunction(exp2, "setPars");
        this.getPars = NlsModel.getElementAsFunctionCall(exp2, "getPars");
    }

    private static Function getElementAsFunction(ListVector m, String name) {
        SEXP element = m.get(name);
        if (element == Null.INSTANCE || !(element instanceof Function)) {
            throw new EvalException("'%s' absent", "m$" + name + "()");
        }
        return (Function)element;
    }

    private static FunctionCall getElementAsFunctionCall(ListVector m, String name) {
        Function element = NlsModel.getElementAsFunction(m, name);
        return FunctionCall.newCall(element, new SEXP[0]);
    }

    public DoubleVector calculateIncrements() {
        return (DoubleVector)this.evaluateCall(this.incr);
    }

    public boolean updateParameters(double[] newParameters) {
        SEXP result = this.context.evaluate(FunctionCall.newCall(this.setPars, new DoubleArrayVector(newParameters)), this.context.getGlobalEnvironment());
        if (!(result instanceof AtomicVector)) {
            throw new EvalException("Unexpected result from setPars", new Object[0]);
        }
        return ((AtomicVector)result).getElementAsLogical(0) == Logical.TRUE;
    }

    public AtomicVector getParameterValues() {
        SEXP exp2 = this.evaluateCall(this.getPars);
        return (AtomicVector)exp2;
    }

    public double calculateDeviation() {
        return this.evaluateCallAsDouble(this.deviance);
    }

    public double getConvergence() {
        return this.evaluateCallAsDouble(this.conv);
    }

    public void trace() {
        this.context.evaluate(this.trace, this.context.getGlobalEnvironment());
    }

    private SEXP evaluateCall(FunctionCall functionCall) {
        return this.context.evaluate(functionCall, this.context.getGlobalEnvironment());
    }

    private double evaluateCallAsDouble(FunctionCall functionCall) {
        SEXP result = this.evaluateCall(functionCall);
        Vector vector2 = (Vector)result;
        return vector2.getElementAsDouble(0);
    }
}

