/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringArrayVector;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Vector;

public final class NamesBuilder {
    private List<String> names = null;
    private int initialCapacity;
    private int size;

    private NamesBuilder(int initialSize, int initialCapacity) {
        this.size = initialSize;
        this.initialCapacity = initialCapacity;
    }

    private NamesBuilder(SEXP exp2) {
        AtomicVector namesVector = exp2.getNames();
        if (namesVector == Null.INSTANCE) {
            this.initialCapacity = this.size = exp2.length();
        } else {
            this.names = Lists.newArrayList((StringVector)namesVector);
            this.size = this.names.size();
        }
    }

    public boolean haveNames() {
        return this.names != null;
    }

    public void add(String name) {
        this.set(this.size, name);
    }

    public void addNA() {
        this.set(this.size, StringVector.NA);
    }

    public void set(int index, String name) {
        if (this.names == null && StringVector.isNA(name)) {
            if (index + 1 > this.size) {
                this.size = index + 1;
            }
        } else {
            this.ensureSize(index + 1);
            this.names.set(index, name);
        }
    }

    private void ensureSize(int newSize) {
        if (this.names == null) {
            this.names = Lists.newArrayListWithCapacity(Math.max(this.initialCapacity, newSize));
        }
        while (newSize > this.names.size()) {
            this.names.add("");
        }
        this.size = this.names.size();
        assert (this.size == newSize);
    }

    public Vector build(int length2) {
        if (this.names == null) {
            return Null.INSTANCE;
        }
        assert (this.names.size() <= length2);
        while (this.names.size() < length2) {
            this.names.add("");
        }
        return new StringArrayVector((Collection<String>)this.names);
    }

    public Vector buildEvenIfEmpty(int length2) {
        if (this.names == null) {
            this.names = new ArrayList<String>();
        }
        while (this.names.size() < length2) {
            this.names.add("");
        }
        return new StringArrayVector((Collection<String>)this.names);
    }

    public Vector build() {
        if (this.names == null) {
            return Null.INSTANCE;
        }
        return new StringArrayVector((Collection<String>)this.names);
    }

    public static NamesBuilder withInitialCapacity(int initialCapacity) {
        return new NamesBuilder(0, initialCapacity);
    }

    public static NamesBuilder clonedFrom(SEXP exp2) {
        return new NamesBuilder(exp2);
    }

    public static NamesBuilder withInitialLength(int initialLength) {
        return new NamesBuilder(initialLength, initialLength);
    }

    public int length() {
        return this.size;
    }

    public void remove(int index) {
        if (this.names != null) {
            this.names.remove(index);
        }
    }

    public int getIndexByName(String name) {
        if (this.names == null) {
            return -1;
        }
        return this.names.indexOf(name);
    }
}

