/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex;

import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.HorizontalBox;
import com.whitemagicsoftware.tex.boxes.VerticalBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import javax.swing.Icon;

public class TeXIcon
implements Icon {
    private Box box;
    private final float size;
    private Insets insets = new Insets(0, 0, 0, 0);

    protected TeXIcon(Box b, float size) {
        this.box = b;
        this.size = size;
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    public void setIconWidth(int width, int alignment) {
        float diff = width - this.getIconWidth();
        if (diff > 0.0f) {
            this.box = new HorizontalBox(this.box, this.box.getWidth() + diff, alignment);
        }
    }

    public void setIconHeight(int height, int alignment) {
        float diff = height - this.getIconHeight();
        if (diff > 0.0f) {
            this.box = new VerticalBox(this.box, diff, alignment);
        }
    }

    @Override
    public int getIconHeight() {
        return (int)((double)((this.box.getHeight() + this.box.getDepth()) * this.size) + 0.99 + (double)this.insets.top + (double)this.insets.bottom);
    }

    @Override
    public int getIconWidth() {
        return (int)((double)(this.box.getWidth() * this.size) + 0.99 + (double)this.insets.left + (double)this.insets.right);
    }

    public float getBaseLine() {
        return (float)(((double)(this.box.getHeight() * this.size) + 0.99 + (double)this.insets.top) / ((double)((this.box.getHeight() + this.box.getDepth()) * this.size) + 0.99 + (double)this.insets.top + (double)this.insets.bottom));
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g;
        RenderingHints oldHints = g2.getRenderingHints();
        AffineTransform oldAt = g2.getTransform();
        Color oldColor = g2.getColor();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.scale(this.size, this.size);
        if (c != null) {
            g2.setColor(c.getForeground());
        }
        this.box.draw(g2, (float)(x + this.insets.left) / this.size, (float)(y + this.insets.top) / this.size + this.box.getHeight());
        g2.setRenderingHints(oldHints);
        g2.setTransform(oldAt);
        g2.setColor(oldColor);
    }
}

