/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.Char;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.ScriptsAtom;
import com.whitemagicsoftware.tex.atoms.SymbolAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.CharBox;
import com.whitemagicsoftware.tex.boxes.HorizontalBox;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.boxes.VerticalBox;

public class BigOperatorAtom
extends Atom {
    private final Atom under;
    private final Atom over;
    protected Atom base;
    private boolean limitsSet;
    private boolean limits;

    public BigOperatorAtom(Atom base, Atom under, Atom over) {
        this.base = base;
        this.under = under;
        this.over = over;
        this.type = 1;
    }

    public BigOperatorAtom(Atom base, Atom under, Atom over, boolean limits) {
        this(base, under, over);
        this.limits = limits;
        this.limitsSet = true;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        float delta;
        Box y;
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        if (this.limitsSet && !this.limits || !this.limitsSet && style >= 2) {
            return new ScriptsAtom(this.base, this.under, this.over).createBox(env);
        }
        if (this.base instanceof SymbolAtom && this.base.type == 1) {
            Char c = tf.getChar(((SymbolAtom)this.base).getName(), style);
            if (style < 2 && tf.hasNextLarger(c)) {
                c = tf.getNextLarger(c, style);
            }
            CharBox x = new CharBox(c);
            x.setShift(-(x.getHeight() + x.getDepth()) / 2.0f - env.getTeXFont().getAxisHeight(env.getStyle()));
            y = new HorizontalBox(x);
            delta = c.getItalic();
            if (delta > 1.0E-7f) {
                y.add(new StrutBox(delta));
            }
        } else {
            delta = 0.0f;
            y = new HorizontalBox(this.base == null ? new StrutBox() : this.base.createBox(env));
        }
        Box x = null;
        Box z = null;
        if (this.over != null) {
            x = this.over.createBox(env.supStyle());
        }
        if (this.under != null) {
            z = this.under.createBox(env.subStyle());
        }
        float maxWidth = Math.max(Math.max(x == null ? 0.0f : x.getWidth(), y.getWidth()), z == null ? 0.0f : z.getWidth());
        x = BigOperatorAtom.changeWidth(x, maxWidth);
        y = BigOperatorAtom.changeWidth(y, maxWidth);
        z = BigOperatorAtom.changeWidth(z, maxWidth);
        VerticalBox vBox = new VerticalBox();
        float bigop5 = tf.getBigOpSpacing5(style);
        float kern = 0.0f;
        float xh = 0.0f;
        if (this.over != null && x != null) {
            vBox.add(new StrutBox(0.0f, bigop5, 0.0f, 0.0f));
            x.setShift(delta / 2.0f);
            vBox.add(x);
            kern = Math.max(tf.getBigOpSpacing1(style), tf.getBigOpSpacing3(style) - x.getDepth());
            vBox.add(new StrutBox(0.0f, kern, 0.0f, 0.0f));
            xh = vBox.getHeight() + vBox.getDepth();
        }
        vBox.add(y);
        if (this.under != null && z != null) {
            float k = Math.max(tf.getBigOpSpacing2(style), tf.getBigOpSpacing4(style) - z.getHeight());
            vBox.add(new StrutBox(0.0f, k, 0.0f, 0.0f));
            z.setShift(-delta / 2.0f);
            vBox.add(z);
            vBox.add(new StrutBox(0.0f, bigop5, 0.0f, 0.0f));
        }
        float h = y.getHeight();
        float total = vBox.getHeight() + vBox.getDepth();
        if (x != null) {
            h += bigop5 + kern + x.getHeight() + x.getDepth();
        }
        vBox.setHeight(h);
        vBox.setDepth(total - h);
        return vBox;
    }

    private static Box changeWidth(Box b, float maxWidth) {
        if (b != null && Math.abs(maxWidth - b.getWidth()) > 1.0E-7f) {
            return new HorizontalBox(b, maxWidth, 2);
        }
        return b;
    }
}

