/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.CharFont;
import com.whitemagicsoftware.tex.Dummy;
import com.whitemagicsoftware.tex.Glue;
import com.whitemagicsoftware.tex.Row;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.CharSymbolAtom;
import com.whitemagicsoftware.tex.atoms.FixedCharAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.HorizontalBox;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.exceptions.EmptyFormulaException;
import java.util.BitSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class RowAtom
extends Atom
implements Row {
    protected List<Atom> elements = new LinkedList<Atom>();
    private Dummy previousAtom;
    private static final BitSet binSet = new BitSet(16);
    private static final BitSet ligKernSet;

    protected RowAtom() {
    }

    public RowAtom(Atom el) {
        if (el != null) {
            if (el instanceof RowAtom) {
                this.elements.addAll(((RowAtom)el).elements);
            } else {
                this.elements.add(el);
            }
        }
    }

    public RowAtom(List<TeXFormula> l) throws EmptyFormulaException {
        for (TeXFormula f : l) {
            Atom root = f.getRoot();
            if (root == null) continue;
            this.elements.add(root);
        }
        if (this.elements.isEmpty()) {
            throw new EmptyFormulaException();
        }
    }

    public final void add(Atom el) {
        if (el != null) {
            this.elements.add(el);
        }
    }

    private void changeToOrd(Dummy cur, Dummy prev, Atom next) {
        int nextType;
        int type = cur.getLeftType();
        if (type == 2 && (prev == null || binSet.get(prev.getRightType()))) {
            cur.setType(0);
        } else if (next != null && cur.getRightType() == 2 && ((nextType = next.getLeftType()) == 3 || nextType == 5 || nextType == 6)) {
            cur.setType(0);
        }
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        TeXFont tf = env.getTeXFont();
        HorizontalBox hBox = new HorizontalBox(env.getColor(), env.getBackground());
        env.reset();
        ListIterator<Atom> it = this.elements.listIterator();
        while (it.hasNext()) {
            Dummy atom = new Dummy(it.next());
            Atom nextAtom = null;
            if (it.hasNext()) {
                nextAtom = it.next();
                it.previous();
            }
            this.changeToOrd(atom, this.previousAtom, nextAtom);
            float kern = 0.0f;
            if (it.hasNext() && atom.getRightType() == 0 && atom.isCharSymbol()) {
                Atom next = it.next();
                if (next instanceof CharSymbolAtom && ligKernSet.get(next.getLeftType())) {
                    atom.markAsTextSymbol();
                    CharFont l = atom.getCharFont(tf);
                    CharFont r = ((CharSymbolAtom)next).getCharFont(tf);
                    CharFont lig = tf.getLigature(l, r);
                    if (lig == null) {
                        kern = tf.getKern(l, r, env.getStyle());
                        it.previous();
                    } else {
                        atom.changeAtom(new FixedCharAtom(lig));
                    }
                } else {
                    it.previous();
                }
            }
            if (it.previousIndex() != 0 && this.previousAtom != null && !this.previousAtom.isKern() && !atom.isKern()) {
                hBox.add(Glue.get(this.previousAtom.getRightType(), atom.getLeftType(), env));
            }
            atom.setPreviousAtom(this.previousAtom);
            Box b = atom.createBox(env);
            hBox.add(b);
            env.setLastFontId(b.getLastFontId());
            if (kern > 1.0E-7f) {
                hBox.add(new StrutBox(0.0f, kern, 0.0f, 0.0f));
            }
            if (atom.isKern()) continue;
            this.previousAtom = atom;
        }
        this.previousAtom = null;
        return hBox;
    }

    @Override
    public void setPreviousAtom(Dummy prev) {
        this.previousAtom = prev;
    }

    @Override
    public int getLeftType() {
        if (this.elements.isEmpty()) {
            return 0;
        }
        return this.elements.get(0).getLeftType();
    }

    @Override
    public int getRightType() {
        if (this.elements.isEmpty()) {
            return 0;
        }
        return this.elements.get(this.elements.size() - 1).getRightType();
    }

    static {
        binSet.set(2);
        binSet.set(1);
        binSet.set(3);
        binSet.set(4);
        binSet.set(6);
        ligKernSet = new BitSet(16);
        ligKernSet.set(0);
        ligKernSet.set(1);
        ligKernSet.set(2);
        ligKernSet.set(3);
        ligKernSet.set(4);
        ligKernSet.set(5);
        ligKernSet.set(6);
    }
}

