/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.boxes;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.List;

public abstract class Box {
    public static final int NO_FONT = -1;
    protected Color foreground;
    protected Color background;
    private Color prevColor;
    protected float width;
    protected float height;
    protected float depth;
    protected float shift;
    protected List<Box> children = new LinkedList<Box>();

    protected Box() {
        this(null, null);
    }

    protected Box(Color fg, Color bg) {
        this.foreground = fg;
        this.background = bg;
    }

    public void add(Box b) {
        this.children.add(b);
    }

    public void add(int pos, Box b) {
        this.children.add(pos, b);
    }

    public float getWidth() {
        return this.width;
    }

    public void setWidth(float w) {
        this.width = w;
    }

    public float getHeight() {
        return this.height;
    }

    public float getDepth() {
        return this.depth;
    }

    public float getShift() {
        return this.shift;
    }

    public void setDepth(float d) {
        this.depth = d;
    }

    public void setHeight(float h) {
        this.height = h;
    }

    public void setShift(float s) {
        this.shift = s;
    }

    public void draw(Graphics2D g, float x, float y) {
    }

    public int getLastFontId() {
        return -1;
    }

    protected void startDraw(Graphics2D g, float x, float y) {
        this.prevColor = g.getColor();
        if (this.background != null) {
            g.setColor(this.background);
            g.fill(new Rectangle2D.Float(x, y - this.height, this.getWidth(), this.getHeight() + this.getDepth()));
        }
        g.setColor(this.foreground == null ? this.prevColor : this.foreground);
    }

    protected void endDraw(Graphics2D g) {
        g.setColor(this.prevColor);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{, width=" + this.width + ", height=" + this.height + ", depth=" + this.depth + ", shift=" + this.shift + "}";
    }
}

