/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.parsers;

import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.exceptions.ResourceParseException;
import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import com.whitemagicsoftware.tex.parsers.TeXFormulaParser;
import com.whitemagicsoftware.tex.resources.XMLResourceReader;
import java.util.Map;
import org.jdom2.Element;

public class PredefinedTeXFormulaParser {
    public static final String RESOURCE_NAME = "PredefinedTeXFormulas.xml";
    private final Element root = new XMLResourceReader("PredefinedTeXFormulas.xml").read();

    public void parse(Map<String, TeXFormula> predefinedTeXFormulas) {
        String enabledAll = PredefinedTeXFormulaParser.getAttrValueAndCheckIfNotNull("enabled", this.root);
        if ("true".equals(enabledAll)) {
            for (Element formula : this.root.getChildren("TeXFormula")) {
                String enabled = PredefinedTeXFormulaParser.getAttrValueAndCheckIfNotNull("enabled", formula);
                if (!"true".equals(enabled)) continue;
                String name = PredefinedTeXFormulaParser.getAttrValueAndCheckIfNotNull("name", formula);
                predefinedTeXFormulas.put(name, new TeXFormulaParser(name, formula).parse());
            }
        }
    }

    private static String getAttrValueAndCheckIfNotNull(String attrName, Element element) throws ResourceParseException {
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            throw new XMLResourceParseException(RESOURCE_NAME, element.getName(), attrName, null);
        }
        return attrValue;
    }
}

