/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.parsers;

import com.whitemagicsoftware.tex.TeXConstants;
import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.exceptions.ResourceParseException;
import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import java.awt.Color;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom2.Element;

public class TeXFormulaParser {
    private static final String ARG_VAL_ATTR = "value";
    private static final String RETURN_EL = "Return";
    private static final String ARG_OBJ_ATTR = "formula";
    private static final Map<String, Class<?>> classMappings = new HashMap();
    private final Map<String, ArgumentValueParser> argValueParsers = new HashMap<String, ArgumentValueParser>();
    private final Map<String, ActionParser> actionParsers = new HashMap<String, ActionParser>();
    private final Map<String, TeXFormula> tempFormulas = new HashMap<String, TeXFormula>();
    private TeXFormula result = new TeXFormula();
    private final String formulaName;
    private final Element formula;

    public TeXFormulaParser(String name, Element formula) {
        this.formulaName = name;
        this.formula = formula;
        this.actionParsers.put("CreateTeXFormula", new CreateTeXFormulaParser());
        this.actionParsers.put("MethodInvocation", new MethodInvocationParser());
        this.actionParsers.put(RETURN_EL, new ReturnParser());
        this.argValueParsers.put("TeXConstants", new TeXConstantsValueParser());
        this.argValueParsers.put("TeXFormula", new TeXFormulaValueParser());
        this.argValueParsers.put("String", new StringValueParser());
        this.argValueParsers.put("float", new FloatValueParser());
        this.argValueParsers.put("int", new IntValueParser());
        this.argValueParsers.put("boolean", new BooleanValueParser());
        this.argValueParsers.put("char", new CharValueParser());
        this.argValueParsers.put("ColorConstant", new ColorConstantValueParser());
    }

    public TeXFormula parse() throws ResourceParseException {
        for (Element obj : this.formula.getChildren()) {
            Element el = obj;
            ActionParser p = this.actionParsers.get(el.getName());
            if (p == null) continue;
            p.parse(el);
        }
        return this.result;
    }

    private Object[] getArgumentValues(List<Element> args) {
        Object[] res = new Object[args.size()];
        int i = 0;
        Iterator<Element> iterator = args.iterator();
        while (iterator.hasNext()) {
            Element obj;
            Element arg = obj = iterator.next();
            String type = TeXFormulaParser.getAttrValueAndCheckIfNotNull("type", arg);
            String value = arg.getAttributeValue(ARG_VAL_ATTR);
            res[i] = this.argValueParsers.get(type).parseValue(value, type);
            ++i;
        }
        return res;
    }

    private static Class[] getArgumentClasses(List<Element> args) throws ResourceParseException {
        Class[] res = new Class[args.size()];
        int i = 0;
        for (Element obj : args) {
            Element arg = obj;
            String type = TeXFormulaParser.getAttrValueAndCheckIfNotNull("type", arg);
            Class<?> cl = classMappings.get(type);
            if (cl == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", "type", "has an invalid class name value!");
            }
            res[i] = cl;
            ++i;
        }
        return res;
    }

    private static void checkNullValue(String value, String type) throws ResourceParseException {
        if (value == null) {
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", ARG_VAL_ATTR, "is required for an argument of type '" + type + "'");
        }
    }

    private static String getAttrValueAndCheckIfNotNull(String attrName, Element element) throws ResourceParseException {
        String attrValue = element.getAttributeValue(attrName);
        if (attrValue == null) {
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", element.getName(), attrName, null);
        }
        return attrValue;
    }

    static {
        classMappings.put("TeXConstants", Integer.TYPE);
        classMappings.put("TeXFormula", TeXFormula.class);
        classMappings.put("String", String.class);
        classMappings.put("float", Float.TYPE);
        classMappings.put("int", Integer.TYPE);
        classMappings.put("boolean", Boolean.TYPE);
        classMappings.put("char", Character.TYPE);
        classMappings.put("ColorConstant", Color.class);
    }

    private class CreateTeXFormulaParser
    implements ActionParser {
        CreateTeXFormulaParser() {
        }

        @Override
        public void parse(Element el) throws ResourceParseException {
            String name = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", el);
            List<Element> args = el.getChildren("Argument");
            Class[] argClasses = TeXFormulaParser.getArgumentClasses(args);
            Object[] argValues = TeXFormulaParser.this.getArgumentValues(args);
            try {
                TeXFormula f = (TeXFormula)TeXFormula.class.getConstructor(argClasses).newInstance(argValues);
                TeXFormulaParser.this.tempFormulas.put(name, f);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new XMLResourceParseException("Error creating the temporary TeXFormula '" + name + "' while constructing the predefined TeXFormula '" + TeXFormulaParser.this.formulaName + "'", e);
            }
        }
    }

    private class MethodInvocationParser
    implements ActionParser {
        MethodInvocationParser() {
        }

        @Override
        public void parse(Element el) throws ResourceParseException {
            String methodName = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", el);
            String objectName = TeXFormulaParser.getAttrValueAndCheckIfNotNull(TeXFormulaParser.ARG_OBJ_ATTR, el);
            TeXFormula object = TeXFormulaParser.this.tempFormulas.get(objectName);
            if (object == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_OBJ_ATTR, "has an unknown temporary TeXFormula name as value : '" + objectName + "'");
            }
            List<Element> args = el.getChildren("Argument");
            Class[] argClasses = TeXFormulaParser.getArgumentClasses(args);
            Object[] argValues = TeXFormulaParser.this.getArgumentValues(args);
            try {
                TeXFormula.class.getMethod(methodName, argClasses).invoke((Object)object, argValues);
            }
            catch (Exception e) {
                throw new XMLResourceParseException("Error invoking the method '" + methodName + "' on the temporary TeXFormula '" + objectName + "' while constructing the predefined TeXFormula '" + TeXFormulaParser.this.formulaName + "'", e);
            }
        }
    }

    private class ReturnParser
    implements ActionParser {
        ReturnParser() {
        }

        @Override
        public void parse(Element el) throws ResourceParseException {
            String name = TeXFormulaParser.getAttrValueAndCheckIfNotNull("name", el);
            TeXFormula res = TeXFormulaParser.this.tempFormulas.get(name);
            if (res == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", TeXFormulaParser.RETURN_EL, "name", "contains an unknown temporary TeXFormula variable name '" + name + "' for the predefined TeXFormula '" + TeXFormulaParser.this.formulaName + "'");
            }
            TeXFormulaParser.this.result = res;
        }
    }

    private static class TeXConstantsValueParser
    implements ArgumentValueParser {
        TeXConstantsValueParser() {
        }

        @Override
        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                return TeXConstants.class.getDeclaredField(value).getInt(null);
            }
            catch (Exception e) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an unknown constant name as value : '" + value + "'", e);
            }
        }
    }

    private class TeXFormulaValueParser
    implements ArgumentValueParser {
        TeXFormulaValueParser() {
        }

        @Override
        public Object parseValue(String value, String type) throws ResourceParseException {
            if (value == null) {
                return null;
            }
            TeXFormula formula = TeXFormulaParser.this.tempFormulas.get(value);
            if (formula == null) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an unknown temporary TeXFormula name as value : '" + value + "'");
            }
            return formula;
        }
    }

    private static class StringValueParser
    implements ArgumentValueParser {
        StringValueParser() {
        }

        @Override
        public Object parseValue(String value, String type) throws ResourceParseException {
            return value;
        }
    }

    private static class FloatValueParser
    implements ArgumentValueParser {
        FloatValueParser() {
        }

        @Override
        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                return Float.valueOf(Float.parseFloat(value));
            }
            catch (NumberFormatException e) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an invalid '" + type + "'-value : '" + value + "'", e);
            }
        }
    }

    private static class IntValueParser
    implements ArgumentValueParser {
        IntValueParser() {
        }

        @Override
        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                int val = Integer.parseInt(value);
                return Float.valueOf(val);
            }
            catch (NumberFormatException e) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an invalid '" + type + "'-value : '" + value + "'", e);
            }
        }
    }

    private static class BooleanValueParser
    implements ArgumentValueParser {
        BooleanValueParser() {
        }

        @Override
        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            if ("true".equals(value)) {
                return Boolean.TRUE;
            }
            if ("false".equals(value)) {
                return Boolean.FALSE;
            }
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an invalid '" + type + "'-value : '" + value + "'");
        }
    }

    private static class CharValueParser
    implements ArgumentValueParser {
        CharValueParser() {
        }

        @Override
        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            if (value.length() == 1) {
                return Character.valueOf(value.charAt(0));
            }
            throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "must have a value that consists of exactly 1 character!");
        }
    }

    private static class ColorConstantValueParser
    implements ArgumentValueParser {
        ColorConstantValueParser() {
        }

        @Override
        public Object parseValue(String value, String type) throws ResourceParseException {
            TeXFormulaParser.checkNullValue(value, type);
            try {
                return Color.class.getDeclaredField(value).get(null);
            }
            catch (Exception e) {
                throw new XMLResourceParseException("PredefinedTeXFormulas.xml", "Argument", TeXFormulaParser.ARG_VAL_ATTR, "has an unknown color constant name as value : '" + value + "'", e);
            }
        }
    }

    private static interface ActionParser {
        public void parse(Element var1) throws ResourceParseException;
    }

    private static interface ArgumentValueParser {
        public Object parseValue(String var1, String var2) throws ResourceParseException;
    }
}

