/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.body.MethodDeclaration;
import com.github.javaparser.ast.body.TypeDeclaration;
import com.github.javaparser.ast.stmt.BlockStmt;
import com.github.javaparser.ast.stmt.Statement;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.List;
import java.util.Optional;

public class Main {
    public static void main(String[] args) throws FileNotFoundException {
        JavaParser parser = new JavaParser();
        File sourceFile = new File(args[0]);
        ParseResult<CompilationUnit> pr = parser.parse(sourceFile);
        Optional<CompilationUnit> ocu = pr.getResult();
        if (ocu.isPresent()) {
            CompilationUnit cu = ocu.get();
            NodeList<TypeDeclaration<?>> types = cu.getTypes();
            for (TypeDeclaration typeDeclaration : types) {
                List<MethodDeclaration> methods = typeDeclaration.getMethods();
                for (MethodDeclaration method : methods) {
                    Optional<BlockStmt> body = method.getBody();
                    String m = String.format("%s::%s( %s )", typeDeclaration.getNameAsString(), method.getNameAsString(), method.getParameters().toString());
                    String mBegan = String.format("System.out.println(\"BEGAN %s\");", m);
                    String mEnded = String.format("System.out.println(\"ENDED %s\");", m);
                    Statement sBegan = StaticJavaParser.parseStatement(mBegan);
                    Statement sEnded = StaticJavaParser.parseStatement(mEnded);
                    body.ifPresent(b -> {
                        int i = b.getStatements().size();
                        b.addStatement(0, sBegan);
                        b.addStatement(i, sEnded);
                    });
                }
                System.out.println(cu.toString());
            }
        }
    }
}

