/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex;

import com.whitemagicsoftware.tex.Char;
import com.whitemagicsoftware.tex.Extension;
import com.whitemagicsoftware.tex.Metrics;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.CharBox;
import com.whitemagicsoftware.tex.boxes.VerticalBox;

public class DelimiterFactory {
    public static Box create(String symbol, TeXEnvironment env, float minHeight) {
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        Char c = tf.getChar(symbol, style);
        Metrics m = c.getMetrics();
        float total = m.getHeight() + m.getDepth();
        while (total < minHeight && tf.hasNextLarger(c)) {
            c = tf.getNextLarger(c, style);
            m = c.getMetrics();
            total = m.getHeight() + m.getDepth();
        }
        if (total >= minHeight) {
            return new CharBox(c);
        }
        if (tf.isExtensionChar(c)) {
            boolean middle;
            VerticalBox vBox = new VerticalBox();
            Extension ext = tf.getExtension(c, style);
            if (ext.hasTop()) {
                c = ext.getTop();
                vBox.add(new CharBox(c));
            }
            if (middle = ext.hasMiddle()) {
                c = ext.getMiddle();
                vBox.add(new CharBox(c));
            }
            if (ext.hasBottom()) {
                c = ext.getBottom();
                vBox.add(new CharBox(c));
            }
            c = ext.getRepeat();
            CharBox rep = new CharBox(c);
            while (vBox.getHeight() + vBox.getDepth() <= minHeight) {
                if (ext.hasTop() && ext.hasBottom()) {
                    vBox.add(1, rep);
                    if (!middle) continue;
                    vBox.add(vBox.getSize() - 1, rep);
                    continue;
                }
                if (ext.hasBottom()) {
                    vBox.add(0, rep);
                    continue;
                }
                vBox.add(rep);
            }
            return vBox;
        }
        return new CharBox(c);
    }
}

