/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex;

import com.whitemagicsoftware.tex.DefaultTeXFont;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXIcon;
import com.whitemagicsoftware.tex.atoms.AccentedAtom;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.BigOperatorAtom;
import com.whitemagicsoftware.tex.atoms.CharAtom;
import com.whitemagicsoftware.tex.atoms.ColorAtom;
import com.whitemagicsoftware.tex.atoms.FencedAtom;
import com.whitemagicsoftware.tex.atoms.FractionAtom;
import com.whitemagicsoftware.tex.atoms.NthRootAtom;
import com.whitemagicsoftware.tex.atoms.OverUnderDelimiterAtom;
import com.whitemagicsoftware.tex.atoms.OverlinedAtom;
import com.whitemagicsoftware.tex.atoms.PhantomAtom;
import com.whitemagicsoftware.tex.atoms.RowAtom;
import com.whitemagicsoftware.tex.atoms.ScriptsAtom;
import com.whitemagicsoftware.tex.atoms.SpaceAtom;
import com.whitemagicsoftware.tex.atoms.SymbolAtom;
import com.whitemagicsoftware.tex.atoms.TypedAtom;
import com.whitemagicsoftware.tex.atoms.UnderOverAtom;
import com.whitemagicsoftware.tex.atoms.UnderlinedAtom;
import com.whitemagicsoftware.tex.atoms.VCenteredAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.exceptions.DelimiterMappingNotFoundException;
import com.whitemagicsoftware.tex.exceptions.EmptyFormulaException;
import com.whitemagicsoftware.tex.exceptions.FormulaNotFoundException;
import com.whitemagicsoftware.tex.exceptions.InvalidAtomTypeException;
import com.whitemagicsoftware.tex.exceptions.InvalidDelimiterException;
import com.whitemagicsoftware.tex.exceptions.InvalidDelimiterTypeException;
import com.whitemagicsoftware.tex.exceptions.InvalidSymbolTypeException;
import com.whitemagicsoftware.tex.exceptions.InvalidTeXFormulaException;
import com.whitemagicsoftware.tex.exceptions.InvalidUnitException;
import com.whitemagicsoftware.tex.exceptions.ParseException;
import com.whitemagicsoftware.tex.exceptions.SymbolNotFoundException;
import com.whitemagicsoftware.tex.parsers.PredefinedTeXFormulaParser;
import com.whitemagicsoftware.tex.parsers.TeXFormulaSettingsParser;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TeXFormula {
    private static final Set<String> commands = new HashSet<String>();
    private static final Set<String> textStyles;
    private static final String[][] delimiterNames;
    private static final char ESCAPE = '\\';
    private static final char L_GROUP = '{';
    private static final char R_GROUP = '}';
    private static final char L_BRACK = '[';
    private static final char R_BRACK = ']';
    private static final int OVER_DEL = 0;
    private static final int UNDER_DEL = 1;
    public static float FONT_SCALE_FACTOR;
    public static float PIXELS_PER_POINT;
    public static final float PREC = 1.0E-7f;
    private static final Map<String, TeXFormula> predefinedTeXFormulas;
    private static final char SUB_SCRIPT = '_';
    private static final char SUPER_SCRIPT = '^';
    private static final char PRIME = '\'';
    private static final String[] symbolMappings;
    private static final String[] delimiterMappings;
    private String texString;
    private int texStringLen;
    private int pos;
    protected Atom root;
    private String textStyle;

    public TeXFormula() {
    }

    public TeXFormula(List<TeXFormula> l) {
        if (l != null) {
            if (l.size() == 1) {
                this.addImpl(l.get(0));
            } else {
                try {
                    this.root = new RowAtom(l);
                }
                catch (EmptyFormulaException e) {
                    this.root = null;
                }
            }
        }
    }

    public TeXFormula(String s) throws ParseException {
        this(s, null);
    }

    private TeXFormula(String s, String textStyle) throws ParseException {
        assert (s != null);
        this.textStyle = textStyle;
        this.parse(s);
    }

    public TeXFormula(TeXFormula f) {
        assert (f != null);
        this.addImpl(f);
    }

    private TeXFormula add(Atom el) {
        if (el != null) {
            if (this.root == null) {
                this.root = el;
            } else {
                if (!(this.root instanceof RowAtom)) {
                    this.root = new RowAtom(this.root);
                }
                ((RowAtom)this.root).add(el);
            }
        }
        return this;
    }

    public TeXFormula add(String s) throws ParseException {
        if (s != null && !s.isEmpty()) {
            this.textStyle = null;
            this.pos = 0;
            this.parse(s);
        }
        return this;
    }

    public TeXFormula add(TeXFormula f) {
        this.addImpl(f);
        return this;
    }

    private void addImpl(TeXFormula f) {
        if (f.root != null) {
            this.add(f.root instanceof RowAtom ? new RowAtom(f.root) : f.root);
        }
    }

    public TeXFormula centerOnAxis() {
        this.root = new VCenteredAtom(this.root);
        return this;
    }

    public TeXFormula addAcc(String s, String accentName) throws InvalidSymbolTypeException, SymbolNotFoundException, ParseException {
        return this.addAcc(new TeXFormula(s), accentName);
    }

    public TeXFormula addAcc(TeXFormula base, String accentName) throws InvalidSymbolTypeException, SymbolNotFoundException {
        return this.add(new AccentedAtom(base == null ? null : base.root, accentName));
    }

    public TeXFormula addAcc(TeXFormula base, TeXFormula accent) throws InvalidSymbolTypeException, InvalidTeXFormulaException {
        return this.add(new AccentedAtom(base == null ? null : base.root, accent));
    }

    public TeXFormula addEmbraced(String s, char l, char r) throws SymbolNotFoundException, InvalidDelimiterException, ParseException, DelimiterMappingNotFoundException {
        return this.addEmbraced(new TeXFormula(s), l, r);
    }

    public TeXFormula addEmbraced(String s, String left, String right) throws SymbolNotFoundException, ParseException, InvalidDelimiterException {
        return this.addEmbraced(new TeXFormula(s), left, right);
    }

    public TeXFormula addEmbraced(TeXFormula f, char l, char r) throws SymbolNotFoundException, InvalidDelimiterException, DelimiterMappingNotFoundException {
        return this.addEmbraced(f, TeXFormula.getCharacterToDelimiterMapping(l), TeXFormula.getCharacterToDelimiterMapping(r));
    }

    public TeXFormula addEmbraced(TeXFormula f, String left, String right) throws SymbolNotFoundException, InvalidDelimiterException {
        return this.add(new FencedAtom(f == null ? null : f.root, TeXFormula.getDelimiterSymbol(left), TeXFormula.getDelimiterSymbol(right)));
    }

    public TeXFormula addFraction(String num, String denom, boolean rule) throws ParseException {
        return this.addFraction(new TeXFormula(num), new TeXFormula(denom), rule);
    }

    public TeXFormula addFraction(String num, String denom, boolean rule, int numAlign, int denomAlign) throws ParseException {
        return this.addFraction(new TeXFormula(num), new TeXFormula(denom), rule, numAlign, denomAlign);
    }

    public TeXFormula addFraction(String num, TeXFormula denom, boolean rule) throws ParseException {
        return this.addFraction(new TeXFormula(num), denom, rule);
    }

    public TeXFormula addFraction(TeXFormula num, String denom, boolean rule) throws ParseException {
        return this.addFraction(num, new TeXFormula(denom), rule);
    }

    public TeXFormula addFraction(TeXFormula num, TeXFormula denom, boolean rule) {
        return this.add(new FractionAtom(num == null ? null : num.root, denom == null ? null : denom.root, rule));
    }

    public TeXFormula addFraction(TeXFormula num, TeXFormula denom, boolean rule, int numAlign, int denomAlign) {
        return this.add(new FractionAtom(num == null ? null : num.root, denom == null ? null : denom.root, rule, numAlign, denomAlign));
    }

    public TeXFormula addNthRoot(String base, String nthRoot) throws ParseException {
        return this.addNthRoot(new TeXFormula(base), new TeXFormula(nthRoot));
    }

    public TeXFormula addNthRoot(String base, TeXFormula nthRoot) throws ParseException {
        return this.addNthRoot(new TeXFormula(base), nthRoot);
    }

    public TeXFormula addNthRoot(TeXFormula base, String nthRoot) throws ParseException {
        return this.addNthRoot(base, new TeXFormula(nthRoot));
    }

    public TeXFormula addNthRoot(TeXFormula base, TeXFormula nthRoot) {
        return this.add(new NthRootAtom(base == null ? null : base.root, nthRoot == null ? null : nthRoot.root));
    }

    public TeXFormula addOp(String op, String low, String up) throws ParseException {
        return this.addOp(new TeXFormula(op), new TeXFormula(low), new TeXFormula(up));
    }

    public TeXFormula addOp(String op, String low, String up, boolean lim) throws ParseException {
        return this.addOp(new TeXFormula(op), new TeXFormula(low), new TeXFormula(up), lim);
    }

    public TeXFormula addOp(TeXFormula op, TeXFormula low, TeXFormula up) {
        return this.add(new BigOperatorAtom(op == null ? null : op.root, low == null ? null : low.root, up == null ? null : up.root));
    }

    public TeXFormula addOp(TeXFormula op, TeXFormula low, TeXFormula up, boolean lim) {
        return this.add(new BigOperatorAtom(op == null ? null : op.root, low == null ? null : low.root, up == null ? null : up.root, lim));
    }

    public TeXFormula addPhantom(String phantom) throws ParseException {
        return this.addPhantom(new TeXFormula(phantom));
    }

    public TeXFormula addPhantom(String phantom, boolean width, boolean height, boolean depth) throws ParseException {
        return this.addPhantom(new TeXFormula(phantom), width, height, depth);
    }

    public TeXFormula addPhantom(TeXFormula phantom) {
        return this.add(new PhantomAtom(phantom == null ? null : phantom.root));
    }

    public TeXFormula addPhantom(TeXFormula phantom, boolean width, boolean height, boolean depth) {
        return this.add(new PhantomAtom(phantom == null ? null : phantom.root, width, height, depth));
    }

    public TeXFormula addSqrt(String base) throws ParseException {
        return this.addSqrt(new TeXFormula(base));
    }

    public TeXFormula addSqrt(TeXFormula base) {
        return this.addNthRoot(base, (TeXFormula)null);
    }

    public TeXFormula addStrut(int unit, float width, float height, float depth) throws InvalidUnitException {
        return this.add(new SpaceAtom(unit, width, height, depth));
    }

    public TeXFormula addStrut(int widthUnit, float width, int heightUnit, float height, int depthUnit, float depth) throws InvalidUnitException {
        return this.add(new SpaceAtom(widthUnit, width, heightUnit, height, depthUnit, depth));
    }

    public TeXFormula addSymbol(String name) throws SymbolNotFoundException {
        return this.add(SymbolAtom.get(name));
    }

    public TeXFormula addSymbol(String name, int type) throws SymbolNotFoundException, InvalidSymbolTypeException {
        return this.add(new SymbolAtom(SymbolAtom.get(name), type));
    }

    private Atom attachScripts(Atom atom) throws ParseException {
        this.skipWhitespace();
        Atom f = atom;
        if (this.pos < this.texStringLen) {
            char ch = this.texString.charAt(this.pos);
            if (ch == '\'') {
                this.replaceAccents();
                ch = this.texString.charAt(this.pos);
            }
            if (ch == '^' || ch == '_') {
                ++this.pos;
                if (ch == '^') {
                    TeXFormula sup = this.getScript();
                    TeXFormula sub = new TeXFormula();
                    this.skipWhitespace();
                    if (this.pos < this.texStringLen && this.texString.charAt(this.pos) == '_') {
                        ++this.pos;
                        sub = this.getScript();
                    }
                    f = f.getRightType() == 1 ? new BigOperatorAtom(f, sub.root, sup.root) : new ScriptsAtom(f, sub.root, sup.root);
                } else {
                    TeXFormula sub = this.getScript();
                    TeXFormula sup = new TeXFormula();
                    this.skipWhitespace();
                    if (this.pos < this.texStringLen && this.texString.charAt(this.pos) == '^') {
                        ++this.pos;
                        sup = this.getScript();
                    }
                    f = f.getRightType() == 1 ? new BigOperatorAtom(f, sub.root, sup.root) : new ScriptsAtom(f, sub.root, sup.root);
                }
            }
        }
        return f;
    }

    private Atom convertCharacter(char c) throws ParseException {
        ++this.pos;
        if (TeXFormula.isSymbol(c)) {
            if (c < symbolMappings.length) {
                String symbolName = symbolMappings[c];
                if (symbolName == null) {
                    String m = String.format("Unknown character: '%s'", Character.valueOf(c));
                    throw new ParseException(m);
                }
                try {
                    return SymbolAtom.get(symbolName);
                }
                catch (SymbolNotFoundException e) {
                    String m = String.format("The character '%c' was mapped to unknown symbol name '%s'", Character.valueOf(c), symbolName);
                    throw new ParseException(m, e);
                }
            }
            String m = String.format("Unknown symbol: '%s'", Character.valueOf(c));
            throw new ParseException(m);
        }
        return new CharAtom(c, this.textStyle);
    }

    public Box createBox(TeXEnvironment style) {
        if (this.root == null) {
            return new StrutBox();
        }
        return this.root.createBox(style);
    }

    public TeXIcon createTeXIcon(int style, float size) {
        return new TeXIcon(this.createBox(new TeXEnvironment(style, new DefaultTeXFont(size))), size);
    }

    public TeXFormula embrace(char left, char right) throws SymbolNotFoundException, InvalidDelimiterException, DelimiterMappingNotFoundException {
        return this.embrace(TeXFormula.getCharacterToDelimiterMapping(left), TeXFormula.getCharacterToDelimiterMapping(right));
    }

    public TeXFormula embrace(String left, String right) throws SymbolNotFoundException, InvalidDelimiterException {
        this.root = new FencedAtom(this.root, TeXFormula.getDelimiterSymbol(left), TeXFormula.getDelimiterSymbol(right));
        return this;
    }

    public TeXFormula fraction(String s, boolean rule) throws ParseException {
        return this.fraction(new TeXFormula(s), rule);
    }

    public TeXFormula fraction(String s, boolean rule, int numAlign, int denomAlign) throws ParseException {
        return this.fraction(new TeXFormula(s), rule, numAlign, denomAlign);
    }

    public TeXFormula fraction(TeXFormula f, boolean rule) {
        this.root = new FractionAtom(this.root, f == null ? null : f.root, rule);
        return this;
    }

    public TeXFormula fraction(TeXFormula f, int unit, float thickness) throws InvalidUnitException {
        this.root = new FractionAtom(this.root, f == null ? null : f.root, unit, thickness);
        return this;
    }

    public TeXFormula fraction(TeXFormula f, int unit, float thickness, int numAlign, int denomAlign) throws InvalidUnitException {
        this.root = new FractionAtom(this.root, f == null ? null : f.root, unit, thickness, numAlign, denomAlign);
        return this;
    }

    public TeXFormula fraction(TeXFormula f, float defaultFactor, int numAlign, int denomAlign) {
        this.root = new FractionAtom(this.root, f == null ? null : f.root, defaultFactor, numAlign, denomAlign);
        return this;
    }

    public TeXFormula fraction(TeXFormula f, boolean rule, int numAlign, int denomAlign) {
        this.root = new FractionAtom(this.root, f == null ? null : f.root, rule, numAlign, denomAlign);
        return this;
    }

    public TeXFormula fractionInvert(String s, boolean rule) throws ParseException {
        return this.fractionInvert(new TeXFormula(s), rule);
    }

    public TeXFormula fractionInvert(String s, boolean rule, int numAlign, int denomAlign) throws ParseException {
        return this.fractionInvert(new TeXFormula(s), rule, numAlign, denomAlign);
    }

    public TeXFormula fractionInvert(TeXFormula f, boolean rule) {
        this.root = new FractionAtom(f == null ? null : f.root, this.root, rule);
        return this;
    }

    public TeXFormula fractionInvert(TeXFormula f, boolean rule, int numAlign, int denomAlign) {
        this.root = new FractionAtom(f == null ? null : f.root, this.root, rule, numAlign, denomAlign);
        return this;
    }

    private String getGroup(char open, char close) throws ParseException {
        int group = 0;
        if (this.pos < this.texStringLen) {
            char ch = this.texString.charAt(this.pos);
            if (ch == open) {
                StringBuilder buf = new StringBuilder();
                ++this.pos;
                while (this.pos < this.texStringLen && ((ch = this.texString.charAt(this.pos)) != close || group != 0)) {
                    if (ch == open) {
                        ++group;
                    } else if (ch == close) {
                        --group;
                    }
                    buf.append(ch);
                    ++this.pos;
                }
                if (this.pos == this.texStringLen) {
                    throw new ParseException("Illegal end, missing '" + close + "'");
                }
                ++this.pos;
                return buf.toString();
            }
            throw new ParseException("Missing '" + open + "'");
        }
        return "";
    }

    private TeXFormula getScript() throws ParseException {
        this.skipWhitespace();
        if (this.pos < this.texStringLen) {
            char ch = this.texString.charAt(this.pos);
            if (ch == '{') {
                return new TeXFormula(this.getGroup('{', '}'));
            }
            ++this.pos;
            return new TeXFormula(Character.toString(ch));
        }
        throw new ParseException("illegal end, missing script!");
    }

    public TeXFormula makePhantom() {
        this.root = new PhantomAtom(this.root);
        return this;
    }

    public TeXFormula makePhantom(boolean width, boolean height, boolean depth) {
        this.root = new PhantomAtom(this.root, width, height, depth);
        return this;
    }

    public TeXFormula nthRoot(String nthRoot) throws ParseException {
        return this.nthRoot(new TeXFormula(nthRoot));
    }

    public TeXFormula nthRoot(TeXFormula nthRoot) {
        this.root = new NthRootAtom(this.root, nthRoot == null ? null : nthRoot.root);
        return this;
    }

    public TeXFormula overline() {
        this.root = new OverlinedAtom(this.root);
        return this;
    }

    private void parse(String s) throws ParseException {
        this.texString = s;
        this.texStringLen = s.length();
        Atom atom = null;
        while (this.pos < this.texStringLen) {
            String msg;
            char ch = this.texString.charAt(this.pos);
            if (Character.isWhitespace(ch)) {
                ++this.pos;
                continue;
            }
            if (ch == '\\') {
                atom = this.processEscape();
                if (atom.isType(10)) continue;
                this.add(this.attachScripts(atom));
                continue;
            }
            if (ch == '{') {
                TeXFormula formula = new TeXFormula(this.getGroup('{', '}'));
                atom = atom != null && atom.isType(10) ? new AccentedAtom(formula.root, atom) : formula.root;
                this.add(this.attachScripts(atom));
                continue;
            }
            if (ch == '}') {
                msg = String.format("Found closing '%s' without opening '%s'", Character.valueOf('}'), Character.valueOf('{'));
                throw new ParseException(msg);
            }
            if (ch == '^' || ch == '_' || ch == '\'') {
                if (this.pos == 0) {
                    throw new ParseException("Every script needs a base: \"^\", \"_\" and \"'\" can't be the first character");
                }
                msg = "Double scripts found, use more braces.";
                throw new ParseException("Double scripts found, use more braces.");
            }
            atom = this.convertCharacter(ch);
            this.add(this.attachScripts(atom));
        }
    }

    private Atom processCommands(String command) throws ParseException {
        TeXFormula nRoot;
        this.skipWhitespace();
        if ("frac".equals(command)) {
            TeXFormula num = new TeXFormula(this.getGroup('{', '}'));
            this.skipWhitespace();
            TeXFormula denom = new TeXFormula(this.getGroup('{', '}'));
            if (num.root == null || denom.root == null) {
                throw new ParseException("Either a numerator or denominator must be present");
            }
            return new FractionAtom(num.root, denom.root, true);
        }
        if (this.pos == this.texStringLen) {
            throw new ParseException("Unrecognized command: '" + command + "'");
        }
        if (this.texString.charAt(this.pos) == '[') {
            nRoot = new TeXFormula(this.getGroup('[', ']'));
            this.skipWhitespace();
        } else {
            nRoot = new TeXFormula();
        }
        Atom base = new TeXFormula((String)this.getGroup((char)'{', (char)'}')).root;
        return new NthRootAtom(base, nRoot.root);
    }

    private String parseCommand() {
        String command;
        int startPos = ++this.pos;
        char ch = '\u0000';
        while (this.pos < this.texStringLen && Character.isAlphabetic(ch = this.texString.charAt(this.pos))) {
            ++this.pos;
        }
        if (ch == '\u0000') {
            return "";
        }
        if (this.pos == startPos) {
            ++this.pos;
        }
        if ("cr".equals(command = this.texString.substring(startPos, this.pos)) && this.pos < this.texStringLen && this.texString.charAt(this.pos) == ' ') {
            ++this.pos;
        }
        return command;
    }

    private Atom processEscape() throws ParseException {
        String command = this.parseCommand();
        SymbolAtom symbolAtom = SymbolAtom.getNullable(command);
        if (symbolAtom != null) {
            return symbolAtom;
        }
        TeXFormula formula = TeXFormula.getNullable(command);
        if (formula != null) {
            return formula.root;
        }
        if (textStyles.contains(command)) {
            this.skipWhitespace();
            TeXFormula tf = new TeXFormula(this.getGroup('{', '}'), command);
            return tf.root;
        }
        if (commands.contains(command)) {
            return this.processCommands(command);
        }
        String msg = String.format("Unknown symbol or command or predefined formula: '%s'", command);
        throw new ParseException(msg);
    }

    public TeXFormula putAccentOver(String accentName) throws InvalidSymbolTypeException, SymbolNotFoundException {
        this.root = new AccentedAtom(this.root, accentName);
        return this;
    }

    public TeXFormula putDelimiterOver(int delimiter) throws InvalidDelimiterTypeException, SymbolNotFoundException {
        if (delimiter < 0 || delimiter >= delimiterNames.length) {
            throw new InvalidDelimiterTypeException();
        }
        String name = delimiterNames[delimiter][0];
        this.root = new OverUnderDelimiterAtom(this.root, null, SymbolAtom.get(name), 1, 0.0f, true);
        return this;
    }

    public TeXFormula putDelimiterOver(int delimiter, String sup, int kernUnit, float kern) throws InvalidDelimiterTypeException, InvalidUnitException, ParseException, SymbolNotFoundException {
        return this.putDelimiterOver(delimiter, new TeXFormula(sup), kernUnit, kern);
    }

    public TeXFormula putDelimiterOver(int delimiter, TeXFormula sup, int kernUnit, float kern) throws InvalidDelimiterTypeException, InvalidUnitException, SymbolNotFoundException {
        if (delimiter < 0 || delimiter >= delimiterNames.length) {
            throw new InvalidDelimiterTypeException();
        }
        String name = delimiterNames[delimiter][0];
        this.root = new OverUnderDelimiterAtom(this.root, sup == null ? null : sup.root, SymbolAtom.get(name), kernUnit, kern, true);
        return this;
    }

    public TeXFormula putDelimiterUnder(int delimiter) throws InvalidDelimiterTypeException, SymbolNotFoundException {
        if (delimiter < 0 || delimiter >= delimiterNames.length) {
            throw new InvalidDelimiterTypeException();
        }
        String name = delimiterNames[delimiter][1];
        this.root = new OverUnderDelimiterAtom(this.root, null, SymbolAtom.get(name), 1, 0.0f, false);
        return this;
    }

    public TeXFormula putDelimiterUnder(int delimiter, String sub, int kernUnit, float kern) throws InvalidDelimiterTypeException, InvalidUnitException, ParseException, SymbolNotFoundException {
        return this.putDelimiterUnder(delimiter, new TeXFormula(sub), kernUnit, kern);
    }

    public TeXFormula putDelimiterUnder(int delimiter, TeXFormula sub, int kernUnit, float kern) throws InvalidDelimiterTypeException, InvalidUnitException, SymbolNotFoundException {
        if (delimiter < 0 || delimiter >= delimiterNames.length) {
            throw new InvalidDelimiterTypeException();
        }
        String name = delimiterNames[delimiter][1];
        this.root = new OverUnderDelimiterAtom(this.root, sub == null ? null : sub.root, SymbolAtom.get(name), kernUnit, kern, false);
        return this;
    }

    public TeXFormula putOver(TeXFormula over, int overUnit, float overSpace, boolean overScriptSize) throws InvalidUnitException {
        this.root = new UnderOverAtom(this.root, over == null ? null : over.root, overUnit, overSpace, overScriptSize, true);
        return this;
    }

    public TeXFormula putOver(String over, int overUnit, float overSpace, boolean overScriptSize) throws InvalidUnitException {
        return this.putOver(over == null ? null : new TeXFormula(over), overUnit, overSpace, overScriptSize);
    }

    public TeXFormula putUnder(String under, int underUnit, float underSpace, boolean underScriptSize) throws InvalidUnitException {
        return this.putUnder(under == null ? null : new TeXFormula(under), underUnit, underSpace, underScriptSize);
    }

    public TeXFormula putUnder(TeXFormula under, int underUnit, float underSpace, boolean underScriptSize) throws InvalidUnitException {
        this.root = new UnderOverAtom(this.root, under == null ? null : under.root, underUnit, underSpace, underScriptSize, false);
        return this;
    }

    public TeXFormula putUnderAndOver(String under, int underUnit, float underSpace, boolean underScriptSize, String over, int overUnit, float overSpace, boolean overScriptSize) throws InvalidUnitException, ParseException {
        return this.putUnderAndOver(under == null ? null : new TeXFormula(under), underUnit, underSpace, underScriptSize, over == null ? null : new TeXFormula(over), overUnit, overSpace, overScriptSize);
    }

    public TeXFormula putUnderAndOver(TeXFormula under, int underUnit, float underSpace, boolean underScriptSize, TeXFormula over, int overUnit, float overSpace, boolean overScriptSize) throws InvalidUnitException {
        this.root = new UnderOverAtom(this.root, under == null ? null : under.root, underUnit, underSpace, underScriptSize, over == null ? null : over.root, overUnit, overSpace, overScriptSize);
        return this;
    }

    private void replaceAccents() {
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append('^');
        buf.append('{');
        buf.append("\\prime");
        for (i = this.pos + 1; i < this.texStringLen; ++i) {
            if (this.texString.charAt(i) == '\'') {
                buf.append("\\prime");
                continue;
            }
            if (!Character.isWhitespace(this.texString.charAt(i))) break;
        }
        buf.append('}');
        this.texString = this.texString.substring(0, this.pos) + buf.toString() + this.texString.substring(i);
        this.texStringLen = this.texString.length();
    }

    public TeXFormula setBackground(Color c) {
        if (c != null) {
            this.root = this.root instanceof ColorAtom ? new ColorAtom(c, null, (ColorAtom)this.root) : new ColorAtom(this.root, c, null);
        }
        return this;
    }

    public TeXFormula setColor(Color c) {
        if (c != null) {
            this.root = this.root instanceof ColorAtom ? new ColorAtom(null, c, (ColorAtom)this.root) : new ColorAtom(this.root, null, c);
        }
        return this;
    }

    public TeXFormula setFixedTypes(int leftType, int rightType) throws InvalidAtomTypeException {
        this.root = new TypedAtom(leftType, rightType, this.root);
        return this;
    }

    public TeXFormula setScripts(String sub, String sup) throws ParseException {
        return this.setScripts(new TeXFormula(sub), new TeXFormula(sup));
    }

    public TeXFormula setScripts(String sub, TeXFormula sup) throws ParseException {
        return this.setScripts(new TeXFormula(sub), sup);
    }

    public TeXFormula setScripts(TeXFormula sub, String sup) throws ParseException {
        return this.setScripts(sub, new TeXFormula(sup));
    }

    public TeXFormula setScripts(TeXFormula sub, TeXFormula sup) {
        this.root = new ScriptsAtom(this.root, sub == null ? null : sub.root, sup == null ? null : sup.root);
        return this;
    }

    public TeXFormula setSubscript(String sub) throws ParseException {
        return this.setSubscript(new TeXFormula(sub));
    }

    public TeXFormula setSubscript(TeXFormula sub) {
        this.root = new ScriptsAtom(this.root, sub == null ? null : sub.root, null);
        return this;
    }

    public TeXFormula setSuperscript(String sup) throws ParseException {
        return this.setSuperscript(new TeXFormula(sup));
    }

    public TeXFormula setSuperscript(TeXFormula sup) {
        this.root = new ScriptsAtom(this.root, null, sup == null ? null : sup.root);
        return this;
    }

    private void skipWhitespace() {
        while (this.pos < this.texStringLen && Character.isWhitespace(this.texString.charAt(this.pos))) {
            ++this.pos;
        }
    }

    public TeXFormula sqrt() {
        return this.nthRoot((TeXFormula)null);
    }

    public TeXFormula underline() {
        this.root = new UnderlinedAtom(this.root);
        return this;
    }

    public static TeXFormula get(String name) throws FormulaNotFoundException {
        TeXFormula formula = TeXFormula.getNullable(name);
        if (formula == null) {
            throw new FormulaNotFoundException(name);
        }
        return new TeXFormula(formula);
    }

    private static TeXFormula getNullable(String name) {
        return predefinedTeXFormulas.get(name);
    }

    private static String getCharacterToDelimiterMapping(char ch) throws DelimiterMappingNotFoundException {
        String str = delimiterMappings[ch];
        if (str == null) {
            throw new DelimiterMappingNotFoundException(ch);
        }
        return str;
    }

    private static SymbolAtom getDelimiterSymbol(String delName) throws SymbolNotFoundException, InvalidDelimiterException {
        SymbolAtom res = null;
        if (delName != null && !(res = SymbolAtom.get(delName)).isDelimiter()) {
            throw new InvalidDelimiterException(delName);
        }
        return res;
    }

    private static boolean isSymbol(char c) {
        return !(c >= '0' && c <= '9' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z');
    }

    public Atom getRoot() {
        return this.root;
    }

    static {
        delimiterNames = new String[][]{{"lbrace", "rbrace"}, {"lsqbrack", "rsqbrack"}, {"lbrack", "rbrack"}, {"downarrow", "downarrow"}, {"uparrow", "uparrow"}, {"updownarrow", "updownarrow"}, {"Downarrow", "Downarrow"}, {"Uparrow", "Uparrow"}, {"Updownarrow", "Updownarrow"}, {"vert", "vert"}, {"Vert", "Vert"}};
        FONT_SCALE_FACTOR = 100.0f;
        PIXELS_PER_POINT = 1.0f;
        predefinedTeXFormulas = new HashMap<String, TeXFormula>();
        TeXFormulaSettingsParser parser = new TeXFormulaSettingsParser();
        symbolMappings = parser.parseSymbolMappings();
        delimiterMappings = parser.parseDelimiterMappings();
        textStyles = parser.parseTextStyles();
        commands.add("frac");
        commands.add("sqrt");
        new PredefinedTeXFormulaParser().parse(predefinedTeXFormulas);
    }
}

