/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.exceptions.InvalidUnitException;

public class SpaceAtom
extends Atom {
    private static final UnitConversion[] unitConversions = new UnitConversion[]{env -> env.getTeXFont().getXHeight(env.getStyle(), env.getLastFontId()), env -> env.getTeXFont().getXHeight(env.getStyle(), env.getLastFontId()), env -> 1.0f / env.getFontPointSize(), env -> TeXFormula.PIXELS_PER_POINT / env.getFontPointSize(), env -> 12.0f * TeXFormula.PIXELS_PER_POINT / env.getFontPointSize(), env -> {
        TeXFont tf = env.getTeXFont();
        return tf.getQuad(env.getStyle(), tf.getMuFontId()) / 18.0f;
    }};
    private boolean blankSpace;
    private float width;
    private float height;
    private float depth;
    private int wUnit;
    private int hUnit;
    private int dUnit;

    public SpaceAtom() {
        this.blankSpace = true;
    }

    public SpaceAtom(int unit, float width, float height, float depth) throws InvalidUnitException {
        SpaceAtom.checkUnit(unit);
        this.wUnit = unit;
        this.hUnit = unit;
        this.dUnit = unit;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    public static void checkUnit(int unit) throws InvalidUnitException {
        if (unit < 0 || unit >= unitConversions.length) {
            throw new InvalidUnitException();
        }
    }

    public SpaceAtom(int widthUnit, float width, int heightUnit, float height, int depthUnit, float depth) throws InvalidUnitException {
        SpaceAtom.checkUnit(widthUnit);
        SpaceAtom.checkUnit(heightUnit);
        SpaceAtom.checkUnit(depthUnit);
        this.wUnit = widthUnit;
        this.hUnit = heightUnit;
        this.dUnit = depthUnit;
        this.width = width;
        this.height = height;
        this.depth = depth;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        if (this.blankSpace) {
            return new StrutBox(env.getSpace());
        }
        return new StrutBox(this.width * SpaceAtom.getFactor(this.wUnit, env), this.height * SpaceAtom.getFactor(this.hUnit, env), this.depth * SpaceAtom.getFactor(this.dUnit, env), 0.0f);
    }

    public static float getFactor(int unit, TeXEnvironment env) {
        return unitConversions[unit].getPixelConversion(env);
    }

    private static interface UnitConversion {
        public float getPixelConversion(TeXEnvironment var1);
    }
}

