/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.resources;

import com.whitemagicsoftware.tex.TeXFormula;
import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import com.whitemagicsoftware.tex.resources.ResourcePath;
import com.whitemagicsoftware.tex.resources.ResourceReader;
import java.awt.Font;
import java.awt.GraphicsEnvironment;

public class FontResourceReader
extends ResourceReader<Font> {
    private static final String DIR_FONT = "fonts";
    private static final String DIR_FONT_COMPUTER_MODERN = "cm";

    public FontResourceReader(String filename) {
        super(ResourcePath.join(DIR_FONT, DIR_FONT_COMPUTER_MODERN, filename));
    }

    public Font read() {
        return super.read(stream -> {
            try {
                Font font = Font.createFont(0, stream).deriveFont(TeXFormula.PIXELS_PER_POINT * TeXFormula.FONT_SCALE_FACTOR);
                GraphicsEnvironment.getLocalGraphicsEnvironment().registerFont(font);
                return font;
            }
            catch (Exception e) {
                throw new XMLResourceParseException(e.getMessage());
            }
        });
    }
}

