/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex;

import com.whitemagicsoftware.tex.CharFont;
import com.whitemagicsoftware.tex.CharTuple;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;

public class FontInfo {
    public static final int NUMBER_OF_CHAR_CODES = 256;
    private static final Font DEFAULT_FONT = new Font(null, 0, 0);
    private static final Map<Integer, Font> fonts = new HashMap<Integer, Font>();
    private final int fontId;
    private final Font font;
    private final float[][] metrics = new float[256][];
    private final Map<CharTuple, Character> lig = new HashMap<CharTuple, Character>();
    private final Map<CharTuple, Float> kern = new HashMap<CharTuple, Float>();
    private final CharFont[] nextLarger = new CharFont[256];
    private final int[][] extensions = new int[256][];
    private char skewChar = (char)65535;
    private final float xHeight;
    private final float space;
    private final float quad;

    public static Font getFont(int fontId) {
        return fonts.getOrDefault(fontId, DEFAULT_FONT);
    }

    public FontInfo(int fontId, Font font, float xHeight, float space, float quad) {
        this.fontId = fontId;
        this.font = font;
        this.xHeight = xHeight;
        this.space = space;
        this.quad = quad;
        FontInfo.putFontInfo(fontId, this);
    }

    public void addKern(char left, char right, float k) {
        this.kern.put(new CharTuple(left, right), Float.valueOf(k));
    }

    public void addLigature(char left, char right, char ligChar) {
        this.lig.put(new CharTuple(left, right), Character.valueOf(ligChar));
    }

    public int[] getExtension(char ch) {
        return this.extensions[ch];
    }

    public float getKern(char left, char right, float factor) {
        Float obj = this.kern.get(new CharTuple(left, right));
        if (obj == null) {
            return 0.0f;
        }
        return obj.floatValue() * factor;
    }

    public CharFont getLigature(char left, char right) {
        Character obj = this.lig.get(new CharTuple(left, right));
        if (obj == null) {
            return null;
        }
        return new CharFont(obj.charValue(), this.fontId);
    }

    public float[] getMetrics(char c) {
        return this.metrics[c];
    }

    public CharFont getNextLarger(char ch) {
        return this.nextLarger[ch];
    }

    public float getQuad(float factor) {
        return this.quad * factor;
    }

    public char getSkewChar() {
        return this.skewChar;
    }

    public float getSpace(float factor) {
        return this.space * factor;
    }

    public float getXHeight(float factor) {
        return this.xHeight * factor;
    }

    public boolean hasSpace() {
        return this.space > 1.0E-7f;
    }

    public void setExtension(char ch, int[] ext) {
        this.extensions[ch] = ext;
    }

    public void setMetrics(char c, float[] arr) {
        this.metrics[c] = arr;
    }

    public void setNextLarger(char ch, char larger, int fontId) {
        this.nextLarger[ch] = new CharFont(larger, fontId);
    }

    public void setSkewChar(char c) {
        this.skewChar = c;
    }

    public Font getFont() {
        return this.font;
    }

    private static void putFontInfo(int fontId, FontInfo fontInfo) {
        fonts.put(fontId, fontInfo.getFont());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{fontId=" + this.fontId + ", font=" + this.font + ", lig=" + this.lig + ", kern=" + this.kern + ", skewChar=" + this.skewChar + ", xHeight=" + this.xHeight + ", space=" + this.space + ", quad=" + this.quad + "}";
    }
}

