/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.SpaceAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.HorizontalBox;
import com.whitemagicsoftware.tex.boxes.HorizontalRuleBox;
import com.whitemagicsoftware.tex.boxes.StrutBox;
import com.whitemagicsoftware.tex.boxes.VerticalBox;
import com.whitemagicsoftware.tex.exceptions.InvalidUnitException;

public class FractionAtom
extends Atom {
    private final boolean noDefault;
    private final int unit;
    private int numAlign = 2;
    private int denomAlign = 2;
    private final Atom numerator;
    private final Atom denominator;
    private float thickness;
    private float defFactor;
    private boolean defFactorSet;

    public FractionAtom(Atom num, Atom den, boolean rule) {
        this(num, den, !rule, 2, 0.0f);
    }

    public FractionAtom(Atom num, Atom den, boolean noDef, int unit, float t) throws InvalidUnitException {
        SpaceAtom.checkUnit(unit);
        this.numerator = num;
        this.denominator = den;
        this.noDefault = noDef;
        this.thickness = t;
        this.unit = unit;
        this.type = 7;
    }

    public FractionAtom(Atom num, Atom den, boolean rule, int numAlign, int denomAlign) {
        this(num, den, rule);
        this.numAlign = this.checkAlignment(numAlign);
        this.denomAlign = this.checkAlignment(denomAlign);
    }

    public FractionAtom(Atom num, Atom den, float defFactor, int numAlign, int denomAlign) {
        this(num, den, true, numAlign, denomAlign);
        this.defFactor = defFactor;
        this.defFactorSet = true;
    }

    public FractionAtom(Atom num, Atom den, int unit, float t, int numAlign, int denomAlign) {
        this(num, den, unit, t);
        this.numAlign = this.checkAlignment(numAlign);
        this.denomAlign = this.checkAlignment(denomAlign);
    }

    public FractionAtom(Atom num, Atom den, int unit, float t) {
        this(num, den, true, unit, t);
    }

    private int checkAlignment(int align) {
        if (align == 0 || align == 1) {
            return align;
        }
        return 2;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        float shiftDown;
        float shiftUp;
        Box denom;
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        float drt = tf.getDefaultRuleThickness(style);
        this.thickness = this.noDefault ? new SpaceAtom(this.unit, 0.0f, this.thickness, 0.0f).createBox(env).getHeight() : (this.defFactorSet ? this.defFactor * drt : drt);
        Box num = this.numerator == null ? new StrutBox() : this.numerator.createBox(env.numStyle());
        Box box = denom = this.denominator == null ? new StrutBox() : this.denominator.createBox(env.denomStyle());
        if (num.getWidth() < denom.getWidth()) {
            num = new HorizontalBox(num, denom.getWidth(), this.numAlign);
        } else {
            denom = new HorizontalBox(denom, num.getWidth(), this.denomAlign);
        }
        if (style < 2) {
            shiftUp = tf.getNum1(style);
            shiftDown = tf.getDenom1(style);
        } else {
            shiftDown = tf.getDenom2(style);
            shiftUp = this.thickness > 0.0f ? tf.getNum2(style) : tf.getNum3(style);
        }
        VerticalBox vBox = new VerticalBox();
        vBox.add(num);
        float axis = tf.getAxisHeight(style);
        if (this.thickness > 0.0f) {
            float clr = style < 2 ? 3.0f * this.thickness : this.thickness;
            float delta = this.thickness / 2.0f;
            float kern1 = shiftUp - num.getDepth() - (axis + delta);
            float kern2 = axis - delta - (denom.getHeight() - shiftDown);
            float delta1 = clr - kern1;
            float delta2 = clr - kern2;
            if (delta1 > 0.0f) {
                shiftUp += delta1;
                kern1 += delta1;
            }
            if (delta2 > 0.0f) {
                shiftDown += delta2;
                kern2 += delta2;
            }
            vBox.add(new StrutBox(0.0f, kern1, 0.0f, 0.0f));
            vBox.add(new HorizontalRuleBox(this.thickness, num.getWidth(), 0.0f));
            vBox.add(new StrutBox(0.0f, kern2, 0.0f, 0.0f));
        } else {
            float kern;
            float clr = style < 2 ? 7.0f * drt : 3.0f * drt;
            float delta = (clr - (kern = shiftUp - num.getDepth() - (denom.getHeight() - shiftDown))) / 2.0f;
            if (delta > 0.0f) {
                shiftUp += delta;
                shiftDown += delta;
                kern += 2.0f * delta;
            }
            vBox.add(new StrutBox(0.0f, kern, 0.0f, 0.0f));
        }
        vBox.add(denom);
        vBox.setHeight(shiftUp + num.getHeight());
        vBox.setDepth(shiftDown + denom.getDepth());
        return vBox;
    }
}

