/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.atoms;

import com.whitemagicsoftware.tex.DelimiterFactory;
import com.whitemagicsoftware.tex.TeXEnvironment;
import com.whitemagicsoftware.tex.TeXFont;
import com.whitemagicsoftware.tex.atoms.Atom;
import com.whitemagicsoftware.tex.atoms.EmptyAtom;
import com.whitemagicsoftware.tex.atoms.SpaceAtom;
import com.whitemagicsoftware.tex.boxes.Box;
import com.whitemagicsoftware.tex.boxes.HorizontalBox;
import com.whitemagicsoftware.tex.boxes.OverBar;
import com.whitemagicsoftware.tex.boxes.StrutBox;

public class NthRootAtom
extends Atom {
    private static final String sqrtSymbol = "sqrt";
    private static final float FACTOR = 0.55f;
    private final Atom base;
    private final Atom root;

    public NthRootAtom(Atom base, Atom root) {
        this.base = base == null ? new EmptyAtom() : base;
        this.root = root == null ? new EmptyAtom() : root;
    }

    @Override
    public Box createBox(TeXEnvironment env) {
        TeXFont tf = env.getTeXFont();
        int style = env.getStyle();
        float drt = tf.getDefaultRuleThickness(style);
        float clr = style < 2 ? tf.getXHeight(style, tf.getChar(sqrtSymbol, style).getFontId()) : drt;
        clr = drt + Math.abs(clr) / 4.0f;
        Box bs = this.base.createBox(env.crampStyle());
        HorizontalBox b = new HorizontalBox(bs);
        b.add(new SpaceAtom(5, 1.0f, 0.0f, 0.0f).createBox(env.crampStyle()));
        float totalH = b.getHeight() + b.getDepth();
        Box rootSign = DelimiterFactory.create(sqrtSymbol, env, totalH + clr + drt);
        float delta = rootSign.getDepth() - (totalH + clr);
        rootSign.setShift(-(b.getHeight() + (clr += delta / 2.0f)));
        OverBar ob = new OverBar((Box)b, clr, rootSign.getHeight());
        ob.setShift(-(b.getHeight() + clr + drt));
        HorizontalBox squareRoot = new HorizontalBox(rootSign);
        squareRoot.add(ob);
        Box r = this.root.createBox(env.rootStyle());
        float bottomShift = 0.55f * (squareRoot.getHeight() + squareRoot.getDepth());
        r.setShift(squareRoot.getDepth() - r.getDepth() - bottomShift);
        Box negativeKern = new SpaceAtom(5, -10.0f, 0.0f, 0.0f).createBox(env);
        HorizontalBox result = new HorizontalBox();
        float pos = r.getWidth() + negativeKern.getWidth();
        if (pos < 0.0f) {
            ((Box)result).add(new StrutBox(-pos));
        }
        ((Box)result).add(r);
        ((Box)result).add(negativeKern);
        ((Box)result).add(squareRoot);
        return result;
    }
}

