/*
 * Decompiled with CFR 0.152.
 */
package com.whitemagicsoftware.tex.parsers;

import com.whitemagicsoftware.tex.exceptions.ResourceParseException;
import com.whitemagicsoftware.tex.exceptions.XMLResourceParseException;
import com.whitemagicsoftware.tex.resources.XMLResourceReader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jdom2.Element;

public class TeXFormulaSettingsParser {
    public static final String RESOURCE_NAME = "TeXFormulaSettings.xml";
    public static final String CHAR_MAPPING_EL = "Map";
    private final Element root = new XMLResourceReader("TeXFormulaSettings.xml").read();

    public String[] parseSymbolMappings() throws ResourceParseException {
        String[] mappings = new String[256];
        Element symbols = this.root.getChild("CharacterToSymbolMappings");
        if (symbols != null) {
            TeXFormulaSettingsParser.addToMap(symbols.getChildren(CHAR_MAPPING_EL), mappings);
        }
        return mappings;
    }

    public String[] parseDelimiterMappings() throws ResourceParseException {
        String[] mappings = new String[256];
        Element delimiters = this.root.getChild("CharacterToDelimiterMappings");
        if (delimiters != null) {
            TeXFormulaSettingsParser.addToMap(delimiters.getChildren(CHAR_MAPPING_EL), mappings);
        }
        return mappings;
    }

    private static void addToMap(List<Element> mapList, String[] table) throws ResourceParseException {
        Iterator<Element> iterator = mapList.iterator();
        while (iterator.hasNext()) {
            Element obj;
            Element map = obj = iterator.next();
            String ch = map.getAttributeValue("char");
            String symbol = map.getAttributeValue("symbol");
            if (ch == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getName(), "char", null);
            }
            if (symbol == null) {
                throw new XMLResourceParseException(RESOURCE_NAME, map.getName(), "symbol", null);
            }
            if (ch.length() == 1) {
                table[ch.charAt((int)0)] = symbol;
                continue;
            }
            throw new XMLResourceParseException(RESOURCE_NAME, map.getName(), "char", "must have a value that contains exactly 1 character!");
        }
    }

    public Set<String> parseTextStyles() throws ResourceParseException {
        HashSet<String> res = new HashSet<String>();
        Element textStyles = this.root.getChild("TextStyles");
        if (textStyles != null) {
            for (Element style : textStyles.getChildren("TextStyle")) {
                String name = style.getAttributeValue("name");
                if (name == null) {
                    throw new XMLResourceParseException(RESOURCE_NAME, style.getName(), "name", null);
                }
                res.add(name);
            }
        }
        return res;
    }
}

