/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.LowerCaseFilter;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.StopwordAnalyzerBase;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cjk.CJKWidthFilter;
import org.apache.lucene.analysis.ja.JapaneseBaseFormFilter;
import org.apache.lucene.analysis.ja.JapaneseKatakanaStemFilter;
import org.apache.lucene.analysis.ja.JapanesePartOfSpeechStopFilter;
import org.apache.lucene.analysis.ja.JapaneseTokenizer;
import org.apache.lucene.analysis.ja.dict.UserDictionary;

public class JapaneseAnalyzer
extends StopwordAnalyzerBase {
    private final int mode$58fad872;
    private final Set<String> stoptags;
    private final UserDictionary userDict = null;

    public JapaneseAnalyzer() {
        this(null, JapaneseTokenizer.DEFAULT_MODE$58fad872, DefaultSetHolder.DEFAULT_STOP_SET, DefaultSetHolder.DEFAULT_STOP_TAGS);
    }

    /*
     * WARNING - void declaration
     */
    private JapaneseAnalyzer(UserDictionary userDict, int mode, CharArraySet stopwords, Set<String> stoptags) {
        super((CharArraySet)var3_3);
        void var2_2;
        void var3_3;
        this.mode$58fad872 = var2_2;
        this.stoptags = stoptags;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final Analyzer.TokenStreamComponents createComponents$2e873add() {
        void var2_2;
        void var1_1;
        JapaneseTokenizer tokenizer = new JapaneseTokenizer(this.userDict, true, false, this.mode$58fad872);
        TokenFilter stream = new JapaneseBaseFormFilter(tokenizer);
        stream = new JapanesePartOfSpeechStopFilter(stream, this.stoptags);
        stream = new CJKWidthFilter(stream);
        stream = new StopFilter(stream, this.stopwords);
        stream = new JapaneseKatakanaStemFilter(stream);
        stream = new LowerCaseFilter(stream);
        return new Analyzer.TokenStreamComponents((Tokenizer)var1_1, (TokenStream)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ CharArraySet access$000(boolean x0, Class x1, String x2, String x3) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return JapaneseAnalyzer.loadStopwordSet(true, (Class<? extends Analyzer>)var1_1, (String)var2_2, (String)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ CharArraySet access$100(boolean x0, Class x1, String x2, String x3) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        return JapaneseAnalyzer.loadStopwordSet(false, (Class<? extends Analyzer>)var1_1, (String)var2_2, (String)var3_3);
    }

    static final class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;
        static final Set<String> DEFAULT_STOP_TAGS;

        static {
            try {
                Iterator<Object> iterator;
                DEFAULT_STOP_SET = JapaneseAnalyzer.access$000(true, JapaneseAnalyzer.class, "stopwords.txt", "#");
                CharArraySet tagset = JapaneseAnalyzer.access$100(false, JapaneseAnalyzer.class, "stoptags.txt", "#");
                DEFAULT_STOP_TAGS = new HashSet<String>();
                iterator = ((CharArraySet)((Object)iterator)).iterator();
                while (iterator.hasNext()) {
                    Object object = iterator.next();
                    char[] chars = (char[])object;
                    DEFAULT_STOP_TAGS.add(new String((char[])object));
                }
                return;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to load default stopword or stoptag set");
            }
        }
    }
}

