/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.rxp90.jsymspell;

import io.gitlab.rxp90.jsymspell.SuggestionStage;
import java.util.Arrays;

public class ChunkArray {
    private static final int CHUNK_SIZE = 4096;
    private static final int DIV_SHIFT = 12;
    private SuggestionStage.Node[][] values;
    private int count;

    ChunkArray(int initialCapacity) {
        int chunks = (initialCapacity + 4096 - 1) / 4096;
        this.values = new SuggestionStage.Node[chunks][];
        Arrays.fill((Object[])this.values, new SuggestionStage.Node[4096]);
    }

    public int add(SuggestionStage.Node value) {
        if (this.count == this.getCapacity()) {
            SuggestionStage.Node[][] newValues = new SuggestionStage.Node[this.values.length + 1][];
            System.arraycopy(this.values, 0, newValues, 0, this.values.length);
            newValues[this.values.length] = new SuggestionStage.Node[4096];
            this.values = newValues;
        }
        this.values[this.row((int)this.count)][this.col((int)this.count)] = value;
        ++this.count;
        return this.count - 1;
    }

    public SuggestionStage.Node get(int index) {
        return this.values[this.row(index)][this.col(index)];
    }

    public void set(int index, SuggestionStage.Node value) {
        this.values[this.row((int)index)][this.col((int)index)] = value;
    }

    private int row(int index) {
        return index >> 12;
    }

    private int col(int index) {
        return index & 0xFFF;
    }

    private int getCapacity() {
        return this.values.length * 4096;
    }

    public int getCount() {
        return this.count;
    }
}

