/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.cn.smart;

import java.io.IOException;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.CharArraySet;
import org.apache.lucene.analysis.StopFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.cn.smart.HMMChineseTokenizer;
import org.apache.lucene.analysis.en.PorterStemFilter;
import org.apache.lucene.util.IOUtils;

public final class SmartChineseAnalyzer
extends Analyzer {
    private final CharArraySet stopWords = DefaultSetHolder.DEFAULT_STOP_SET;

    public SmartChineseAnalyzer() {
        this(true);
    }

    private SmartChineseAnalyzer(boolean useDefaultStopWords) {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Analyzer.TokenStreamComponents createComponents$2e873add() {
        void var2_2;
        void var1_1;
        HMMChineseTokenizer tokenizer;
        TokenStream result = tokenizer = new HMMChineseTokenizer();
        result = new PorterStemFilter(result);
        if (!this.stopWords.isEmpty()) {
            result = new StopFilter(result, this.stopWords);
        }
        return new Analyzer.TokenStreamComponents((Tokenizer)var1_1, (TokenStream)var2_2);
    }

    static final class DefaultSetHolder {
        static final CharArraySet DEFAULT_STOP_SET;

        static {
            try {
                String string = "//";
                Reader reader = IOUtils.getDecodingReader(SmartChineseAnalyzer.class, "stopwords.txt", StandardCharsets.UTF_8);
                DEFAULT_STOP_SET = CharArraySet.unmodifiableSet(Analyzer.TokenStreamComponents.getWordSet(reader, string, new CharArraySet(16, false)));
                return;
            }
            catch (IOException iOException) {
                throw new RuntimeException("Unable to load default stopword set");
            }
        }
    }
}

