/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.ja.dict.BinaryDictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOUtils;

public final class CharacterDefinition {
    private static int CLASS_COUNT;
    private final byte[] characterCategoryMap = new byte[65536];
    private final boolean[] invokeMap = new boolean[CLASS_COUNT];
    private final boolean[] groupMap = new boolean[CLASS_COUNT];
    public static final byte NGRAM;
    private static byte KANJI;
    private static byte KANJINUMERIC;

    /*
     * WARNING - void declaration
     */
    private CharacterDefinition() throws IOException {
        InputStream is = null;
        try {
            is = BinaryDictionary.getClassResource(this.getClass(), ".dat");
            is = new BufferedInputStream(is);
            InputStreamDataInput in = new InputStreamDataInput(is);
            CodecUtil.checkHeader(in, "kuromoji_cd", 1, 1);
            ((DataInput)in).readBytes(this.characterCategoryMap, 0, 65536);
            for (int i = 0; i < CLASS_COUNT; ++i) {
                byte b = ((DataInput)in).readByte();
                this.invokeMap[i] = (b & 1) != 0;
                this.groupMap[i] = (b & 2) != 0;
            }
        }
        catch (Throwable throwable) {
            void var1_1;
            IOUtils.closeWhileHandlingException(new Closeable[]{var1_1});
            throw throwable;
        }
        IOUtils.close(is);
    }

    /*
     * WARNING - void declaration
     */
    public final byte getCharacterClass(char c) {
        void var1_1;
        return this.characterCategoryMap[var1_1];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isInvoke(char c) {
        void var1_1;
        return this.invokeMap[this.characterCategoryMap[var1_1]];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isGroup(char c) {
        void var1_1;
        return this.groupMap[this.characterCategoryMap[var1_1]];
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isKanji(char c) {
        void var1_1;
        byte characterClass = this.characterCategoryMap[c];
        return characterClass == KANJI || var1_1 == KANJINUMERIC;
    }

    public static CharacterDefinition getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /* synthetic */ CharacterDefinition(byte by) throws IOException {
        this();
    }

    static {
        CharacterClass.values$6b6da47();
        CLASS_COUNT = 12;
        NGRAM = 0;
        KANJI = (byte)10;
        KANJINUMERIC = (byte)11;
    }

    static final class SingletonHolder {
        static final CharacterDefinition INSTANCE;

        /*
         * WARNING - void declaration
         */
        static {
            try {
                INSTANCE = new CharacterDefinition(0);
                return;
            }
            catch (IOException ioe) {
                void var0;
                throw new RuntimeException("Cannot load CharacterDefinition.", (Throwable)var0);
            }
        }
    }

    static final class CharacterClass
    extends Enum<CharacterClass> {
        public static final int NGRAM$59d4118d = 1;
        public static final int DEFAULT$59d4118d = 2;
        public static final int SPACE$59d4118d = 3;
        public static final int SYMBOL$59d4118d = 4;
        public static final int NUMERIC$59d4118d = 5;
        public static final int ALPHA$59d4118d = 6;
        public static final int CYRILLIC$59d4118d = 7;
        public static final int GREEK$59d4118d = 8;
        public static final int HIRAGANA$59d4118d = 9;
        public static final int KATAKANA$59d4118d = 10;
        public static final int KANJI$59d4118d = 11;
        public static final int KANJINUMERIC$59d4118d = 12;
        private static final /* synthetic */ int[] $VALUES$945c648;

        public static int[] values$6b6da47() {
            return (int[])$VALUES$945c648.clone();
        }

        static {
            $VALUES$945c648 = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12};
        }
    }
}

