/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ja.dict;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ja.dict.BinaryDictionary;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.store.InputStreamDataInput;
import org.apache.lucene.util.IOUtils;

public final class ConnectionCosts {
    private final short[][] costs;

    /*
     * WARNING - void declaration
     */
    private ConnectionCosts(BinaryDictionary.ResourceScheme scheme, String path) throws IOException {
        void var1_3;
        InputStream is = null;
        try {
            is = BinaryDictionary.getResource(scheme, path.replace('.', '/') + ".dat");
            is = new BufferedInputStream(is);
            InputStreamDataInput in = new InputStreamDataInput(is);
            CodecUtil.checkHeader(in, "kuromoji_cc", 1, 1);
            int forwardSize = in.readVInt();
            int n = in.readVInt();
            short[][] costs = new short[n][forwardSize];
            int accum2 = 0;
            for (int j = 0; j < costs.length; ++j) {
                short[] a = costs[j];
                for (int i = 0; i < a.length; ++i) {
                    InputStreamDataInput accum2 = in;
                    a[i] = (short)(accum2 += Analyzer.TokenStreamComponents.zigZagDecode(accum2.readVInt()));
                }
            }
        }
        catch (Throwable costs) {
            void var3_6;
            IOUtils.closeWhileHandlingException(new Closeable[]{var3_6});
            throw costs;
        }
        IOUtils.close(is);
        this.costs = var1_3;
    }

    private ConnectionCosts() throws IOException {
        this(BinaryDictionary.ResourceScheme.CLASSPATH, ConnectionCosts.class.getName());
    }

    /*
     * WARNING - void declaration
     */
    public final int get(int forwardId, int backwardId) {
        void var1_1;
        void var2_2;
        return this.costs[var2_2][var1_1];
    }

    public static ConnectionCosts getInstance() {
        return SingletonHolder.INSTANCE;
    }

    /* synthetic */ ConnectionCosts(byte by) throws IOException {
        this();
    }

    static final class SingletonHolder {
        static final ConnectionCosts INSTANCE;

        /*
         * WARNING - void declaration
         */
        static {
            try {
                INSTANCE = new ConnectionCosts(0);
                return;
            }
            catch (IOException ioe) {
                void var0;
                throw new RuntimeException("Cannot load ConnectionCosts.", (Throwable)var0);
            }
        }
    }
}

