/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ko;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.ko.DecompoundToken;
import org.apache.lucene.analysis.ko.DictionaryToken;
import org.apache.lucene.analysis.ko.POS;
import org.apache.lucene.analysis.ko.Token;
import org.apache.lucene.analysis.ko.dict.CharacterDefinition;
import org.apache.lucene.analysis.ko.dict.ConnectionCosts;
import org.apache.lucene.analysis.ko.dict.Dictionary;
import org.apache.lucene.analysis.ko.dict.TokenInfoDictionary;
import org.apache.lucene.analysis.ko.dict.TokenInfoFST;
import org.apache.lucene.analysis.ko.dict.UnknownDictionary;
import org.apache.lucene.analysis.ko.dict.UserDictionary;
import org.apache.lucene.analysis.ko.tokenattributes.PartOfSpeechAttribute;
import org.apache.lucene.analysis.ko.tokenattributes.ReadingAttribute;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionLengthAttribute;
import org.apache.lucene.analysis.util.RollingCharBuffer;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.AttributeFactory;
import org.apache.lucene.util.IntsRef;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.fst.FST;

public final class KoreanTokenizer
extends Tokenizer {
    public static final int DEFAULT_DECOMPOUND$38182e60 = DecompoundMode.DISCARD$38182e60;
    private final EnumMap<Type, Dictionary> dictionaryMap = new EnumMap(Type.class);
    private final TokenInfoFST fst;
    private final TokenInfoDictionary dictionary;
    private final UnknownDictionary unkDictionary;
    private final ConnectionCosts costs;
    private final UserDictionary userDictionary;
    private final CharacterDefinition characterDefinition;
    private final FST.Arc<Long> arc = new FST.Arc();
    private final FST.BytesReader fstReader;
    private final IntsRef wordIdRef = new IntsRef();
    private final FST.BytesReader userFSTReader;
    private final TokenInfoFST userFST;
    private final boolean discardPunctuation;
    private final int mode$38182e60;
    private final boolean outputUnknownUnigrams;
    private final RollingCharBuffer buffer = new RollingCharBuffer();
    private final WrappedPositionArray positions = new WrappedPositionArray();
    private boolean end;
    private int lastBackTracePos;
    private int pos;
    private final List<Token> pending = new ArrayList<Token>();
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);
    private final PositionIncrementAttribute posIncAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final PositionLengthAttribute posLengthAtt = this.addAttribute(PositionLengthAttribute.class);
    private final PartOfSpeechAttribute posAtt = this.addAttribute(PartOfSpeechAttribute.class);
    private final ReadingAttribute readingAtt = this.addAttribute(ReadingAttribute.class);

    public KoreanTokenizer() {
        this(DEFAULT_TOKEN_ATTRIBUTE_FACTORY, null, DEFAULT_DECOMPOUND$38182e60, false, true);
    }

    /*
     * WARNING - void declaration
     */
    public KoreanTokenizer(AttributeFactory factory, UserDictionary userDictionary, int mode, boolean outputUnknownUnigrams) {
        this((AttributeFactory)var1_1, (UserDictionary)var2_2, (int)var3_3, outputUnknownUnigrams, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private KoreanTokenizer(AttributeFactory factory, UserDictionary userDictionary, int mode, boolean outputUnknownUnigrams, boolean discardPunctuation) {
        this((AttributeFactory)var1_1, TokenInfoDictionary.getInstance(), UnknownDictionary.getInstance(), ConnectionCosts.getInstance(), (UserDictionary)var2_2, (int)var3_3, outputUnknownUnigrams, true);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private KoreanTokenizer(AttributeFactory factory, TokenInfoDictionary systemDictionary, UnknownDictionary unkDictionary, ConnectionCosts connectionCosts, UserDictionary userDictionary, int mode, boolean outputUnknownUnigrams, boolean discardPunctuation) {
        super((AttributeFactory)var1_1);
        void var3_3;
        void var2_2;
        void var1_1;
        this.dictionary = var2_2;
        this.fst = this.dictionary.getFST();
        this.unkDictionary = unkDictionary;
        this.characterDefinition = unkDictionary.getCharacterDefinition();
        this.costs = connectionCosts;
        this.userDictionary = userDictionary;
        this.fstReader = this.fst.getBytesReader();
        if (userDictionary != null) {
            KoreanTokenizer koreanTokenizer = this;
            UserDictionary userDictionary2 = userDictionary;
            throw null;
        }
        this.userFST = null;
        this.userFSTReader = null;
        this.mode$38182e60 = mode;
        this.outputUnknownUnigrams = outputUnknownUnigrams;
        this.discardPunctuation = discardPunctuation;
        this.buffer.reset(this.input);
        this.resetState();
        this.dictionaryMap.put(Type.KNOWN, this.dictionary);
        this.dictionaryMap.put(Type.UNKNOWN, (Dictionary)var3_3);
        this.dictionaryMap.put(Type.USER, userDictionary);
    }

    @Override
    public final void close() throws IOException {
        super.close();
        this.buffer.reset(this.input);
    }

    @Override
    public final void reset() throws IOException {
        super.reset();
        this.buffer.reset(this.input);
        this.resetState();
    }

    private void resetState() {
        this.positions.reset();
        this.pos = 0;
        this.end = false;
        this.lastBackTracePos = 0;
        this.pending.clear();
        this.positions.get(0).add(0, 0, -1, -1, -1, -1, Type.KNOWN);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void end() throws IOException {
        void var1_1;
        super.end();
        KoreanTokenizer koreanTokenizer = this;
        int finalOffset = koreanTokenizer.correctOffset(koreanTokenizer.pos);
        void v1 = var1_1;
        this.offsetAtt.setOffset((int)v1, (int)v1);
    }

    /*
     * WARNING - void declaration
     */
    private void add(Dictionary dict, Position fromPosData, int wordPos, int endPos, int wordID, Type type) {
        void var3_3;
        void var2_2;
        void var1_1;
        POS.Tag leftPOS = dict.getLeftPOS(wordID);
        int wordCost = dict.getWordCost(wordID);
        int leftID = dict.getLeftId(wordID);
        int leastCost = Integer.MAX_VALUE;
        int leastIDX = -1;
        assert (fromPosData.count > 0);
        for (int idx = 0; idx < fromPosData.count; ++idx) {
            int cost;
            int numSpaces22 = wordPos - fromPosData.pos;
            int n = fromPosData.costs[idx] + this.costs.get(fromPosData.lastRightID[idx], leftID);
            int n2 = numSpaces22;
            POS.Tag numSpaces22 = leftPOS;
            int n3 = 0;
            if (n2 > 0) {
                switch (numSpaces22) {
                    case E: 
                    case J: 
                    case VCP: 
                    case XSA: 
                    case XSN: 
                    case XSV: {
                        n3 = 3000;
                    }
                }
            }
            if ((cost = n + n3) >= leastCost) continue;
            leastCost = cost;
            leastIDX = idx;
        }
        this.positions.get(endPos).add(leastCost += wordCost, var1_1.getRightId(wordID), var2_2.pos, (int)var3_3, leastIDX, wordID, type);
    }

    @Override
    public final boolean incrementToken() throws IOException {
        int n;
        KoreanTokenizer koreanTokenizer;
        block0: while (this.pending.size() == 0) {
            int n2;
            int n3;
            Position position;
            if (this.end) {
                return false;
            }
            koreanTokenizer = this;
            n = -1;
            while (koreanTokenizer.buffer.get(koreanTokenizer.pos) != -1) {
                int n4;
                int n5;
                position = koreanTokenizer.positions.get(koreanTokenizer.pos);
                int n6 = n3 = koreanTokenizer.positions.getNextPos() == koreanTokenizer.pos + 1 ? 1 : 0;
                if (position.count == 0) {
                    ++koreanTokenizer.pos;
                    continue;
                }
                if (koreanTokenizer.pos > koreanTokenizer.lastBackTracePos && position.count == 1 && n3 != 0) {
                    koreanTokenizer.backtrace(position, 0);
                    position.costs[0] = 0;
                    if (koreanTokenizer.pending.size() > 0) continue block0;
                }
                if (koreanTokenizer.pos - koreanTokenizer.lastBackTracePos >= 1024) {
                    Position position2;
                    n2 = -1;
                    int n7 = Integer.MAX_VALUE;
                    Position position3 = null;
                    for (n3 = koreanTokenizer.pos; n3 < koreanTokenizer.positions.getNextPos(); ++n3) {
                        position2 = koreanTokenizer.positions.get(n3);
                        for (n5 = 0; n5 < position2.count; ++n5) {
                            n4 = position2.costs[n5];
                            if (n4 >= n7) continue;
                            n7 = n4;
                            n2 = n5;
                            position3 = position2;
                        }
                    }
                    assert (n2 != -1);
                    for (n3 = koreanTokenizer.pos; n3 < koreanTokenizer.positions.getNextPos(); ++n3) {
                        position2 = koreanTokenizer.positions.get(n3);
                        if (position2 != position3) {
                            position = position2;
                            position2.count = 0;
                            continue;
                        }
                        if (n2 != 0) {
                            position2.costs[0] = position2.costs[n2];
                            position2.lastRightID[0] = position2.lastRightID[n2];
                            position2.backPos[0] = position2.backPos[n2];
                            position2.backWordPos[0] = position2.backWordPos[n2];
                            position2.backIndex[0] = position2.backIndex[n2];
                            position2.backID[0] = position2.backID[n2];
                            position2.backType[0] = position2.backType[n2];
                        }
                        position2.count = 1;
                    }
                    koreanTokenizer.backtrace(position3, 0);
                    Arrays.fill(position3.costs, 0, position3.count, 0);
                    if (koreanTokenizer.pos != position3.pos) {
                        assert (koreanTokenizer.pos < position3.pos);
                        koreanTokenizer.pos = position3.pos;
                    }
                    if (koreanTokenizer.pending.size() <= 0) continue;
                    continue block0;
                }
                if (Character.getType(koreanTokenizer.buffer.get(koreanTokenizer.pos)) == 12) {
                    n2 = koreanTokenizer.buffer.get(++koreanTokenizer.pos);
                    while (n2 != -1 && Character.getType(n2) == 12) {
                        ++koreanTokenizer.pos;
                        n2 = koreanTokenizer.buffer.get(koreanTokenizer.pos);
                    }
                }
                if (koreanTokenizer.buffer.get(koreanTokenizer.pos) == -1) {
                    koreanTokenizer.pos = position.pos;
                }
                n2 = 0;
                if (koreanTokenizer.userFST != null) {
                    koreanTokenizer.userFST.getFirstArc(koreanTokenizer.arc);
                    int n8 = 0;
                    int n9 = 0;
                    n3 = 0;
                    int n10 = 0;
                    n5 = koreanTokenizer.pos;
                    while ((n4 = koreanTokenizer.buffer.get(n5)) != -1 && koreanTokenizer.userFST.findTargetArc(n4, koreanTokenizer.arc, koreanTokenizer.arc, n5 == koreanTokenizer.pos, koreanTokenizer.userFSTReader) != null) {
                        n8 += koreanTokenizer.arc.output().intValue();
                        if (koreanTokenizer.arc.isFinal()) {
                            n9 = n5;
                            n3 = n8;
                            n10 = koreanTokenizer.arc.nextFinalOutput().intValue();
                            n2 = 1;
                        }
                        ++n5;
                    }
                    if (n2 != 0 && n9 > n) {
                        KoreanTokenizer koreanTokenizer2 = koreanTokenizer;
                        koreanTokenizer2.add(koreanTokenizer2.userDictionary, position, koreanTokenizer.pos, n9 + 1, n3 + n10, Type.USER);
                        n = Math.max(n, n9);
                    }
                }
                if (n2 == 0) {
                    koreanTokenizer.fst.getFirstArc(koreanTokenizer.arc);
                    int n11 = 0;
                    int n12 = koreanTokenizer.pos;
                    while ((n3 = koreanTokenizer.buffer.get(n12)) != -1 && koreanTokenizer.fst.findTargetArc(n3, koreanTokenizer.arc, koreanTokenizer.arc, n12 == koreanTokenizer.pos, koreanTokenizer.fstReader) != null) {
                        n11 += koreanTokenizer.arc.output().intValue();
                        if (koreanTokenizer.arc.isFinal()) {
                            koreanTokenizer.dictionary.lookupWordIds(n11 + koreanTokenizer.arc.nextFinalOutput().intValue(), koreanTokenizer.wordIdRef);
                            for (int i = 0; i < koreanTokenizer.wordIdRef.length; ++i) {
                                KoreanTokenizer koreanTokenizer3 = koreanTokenizer;
                                koreanTokenizer3.add(koreanTokenizer3.dictionary, position, koreanTokenizer.pos, n12 + 1, koreanTokenizer.wordIdRef.ints[koreanTokenizer.wordIdRef.offset + i], Type.KNOWN);
                                n2 = 1;
                            }
                        }
                        ++n12;
                    }
                }
                if (-1 > position.pos) {
                    ++koreanTokenizer.pos;
                    continue;
                }
                char c = (char)koreanTokenizer.buffer.get(koreanTokenizer.pos);
                if (n2 == 0 || koreanTokenizer.characterDefinition.isInvoke(c)) {
                    byte by = koreanTokenizer.characterDefinition.getCharacterClass(c);
                    if (!koreanTokenizer.characterDefinition.isGroup(c)) {
                        n3 = 1;
                    } else {
                        int n13;
                        n3 = 1;
                        Character.UnicodeScript unicodeScript = Character.UnicodeScript.of(c);
                        n5 = KoreanTokenizer.isPunctuation(c) ? 1 : 0;
                        n4 = Character.isDigit(c) ? 1 : 0;
                        n2 = koreanTokenizer.pos + 1;
                        while (n3 < 1024 && (n13 = koreanTokenizer.buffer.get(n2)) != -1) {
                            char c2 = (char)n13;
                            int n14 = Character.getType(c2);
                            Character.UnicodeScript unicodeScript2 = unicodeScript;
                            Character.UnicodeScript unicodeScript3 = Character.UnicodeScript.of(n13);
                            Character.UnicodeScript unicodeScript4 = unicodeScript3;
                            boolean bl = unicodeScript2 == unicodeScript4 || KoreanTokenizer.isCommonOrInherited(unicodeScript2) || KoreanTokenizer.isCommonOrInherited(unicodeScript4) || n14 == 6;
                            if (!bl || KoreanTokenizer.isPunctuation(c2, n14) != n5 || Character.isDigit(c2) != n4 || !koreanTokenizer.characterDefinition.isGroup(c2)) break;
                            ++n3;
                            if (KoreanTokenizer.isCommonOrInherited(unicodeScript) && !KoreanTokenizer.isCommonOrInherited(unicodeScript3)) {
                                unicodeScript = unicodeScript3;
                                by = koreanTokenizer.characterDefinition.getCharacterClass(c2);
                            }
                            ++n2;
                        }
                    }
                    koreanTokenizer.unkDictionary.lookupWordIds(by, koreanTokenizer.wordIdRef);
                    for (int i = 0; i < koreanTokenizer.wordIdRef.length; ++i) {
                        KoreanTokenizer koreanTokenizer4 = koreanTokenizer;
                        koreanTokenizer4.add(koreanTokenizer4.unkDictionary, position, koreanTokenizer.pos, koreanTokenizer.pos + n3, koreanTokenizer.wordIdRef.ints[koreanTokenizer.wordIdRef.offset + i], Type.UNKNOWN);
                    }
                }
                ++koreanTokenizer.pos;
            }
            koreanTokenizer.end = true;
            if (koreanTokenizer.pos <= 0) continue;
            position = koreanTokenizer.positions.get(koreanTokenizer.pos);
            n3 = Integer.MAX_VALUE;
            n2 = -1;
            for (int i = 0; i < position.count; ++i) {
                int n15 = position.costs[i] + koreanTokenizer.costs.get(position.lastRightID[i], 0);
                if (n15 >= n3) continue;
                n3 = n15;
                n2 = i;
            }
            koreanTokenizer.backtrace(position, n2);
        }
        Token token = this.pending.remove(this.pending.size() - 1);
        int length = token.getLength();
        this.clearAttributes();
        assert (length > 0);
        this.termAtt.copyBuffer(token.getSurfaceForm(), token.getOffset(), n);
        this.offsetAtt.setOffset(this.correctOffset(token.getStartOffset()), this.correctOffset(token.getEndOffset()));
        this.posIncAtt.setPositionIncrement(token.getPositionIncrement());
        this.posLengthAtt.setPositionLength(((Token)((Object)koreanTokenizer)).getPositionLength());
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void backtrace(Position endPosData, int fromIDX) {
        void var1_2;
        int endPos = endPosData.pos;
        char[] fragment = this.buffer.get(this.lastBackTracePos, endPos - this.lastBackTracePos);
        int pos = endPos;
        while (pos > this.lastBackTracePos) {
            int charLen;
            void bestIDX;
            Position posData = this.positions.get(pos);
            assert (bestIDX < posData.count);
            int backPos = posData.backPos[bestIDX];
            int backWordPos = posData.backWordPos[bestIDX];
            assert (backPos >= this.lastBackTracePos) : "backPos=" + backPos + " vs lastBackTracePos=" + this.lastBackTracePos;
            int length = pos - backWordPos;
            Type backType = posData.backType[bestIDX];
            int backID = posData.backID[bestIDX];
            int nextBestIDX = posData.backIndex[bestIDX];
            int fragmentOffset = backWordPos - this.lastBackTracePos;
            assert (fragmentOffset >= 0);
            Dictionary dict = this.getDict(backType);
            if (this.outputUnknownUnigrams && backType == Type.UNKNOWN) {
                for (int i = length - 1; i >= 0; --i) {
                    charLen = 1;
                    if (i > 0 && Character.isLowSurrogate(fragment[fragmentOffset + i])) {
                        --i;
                        charLen = 2;
                    }
                    DictionaryToken token = new DictionaryToken(Type.UNKNOWN, this.unkDictionary, CharacterDefinition.NGRAM, fragment, fragmentOffset + i, charLen, backWordPos + i, backWordPos + i + charLen);
                    this.pending.add(token);
                }
            } else {
                void token;
                void i;
                int n = backWordPos;
                DictionaryToken token2 = new DictionaryToken((Type)i, dict, charLen, fragment, fragmentOffset, (int)token, n, n + token);
                if (token2.getPOSType$409c8ee9() == POS.Type.MORPHEME$11ec4116 || this.mode$38182e60 == DecompoundMode.NONE$38182e60) {
                    if (!this.shouldFilterToken(token2)) {
                        this.pending.add(token2);
                    }
                } else {
                    Dictionary.Morpheme[] morphemes = token2.getMorphemes();
                    if (morphemes == null) {
                        this.pending.add(token2);
                    } else {
                        int endOffset = backWordPos + token;
                        int posLen = 0;
                        for (int i2 = morphemes.length - 1; i2 >= 0; --i2) {
                            DecompoundToken compoundToken;
                            Dictionary.Morpheme morpheme = morphemes[i2];
                            if (token2.getPOSType$409c8ee9() == POS.Type.COMPOUND$11ec4116) {
                                assert (endOffset - morpheme.surfaceForm.length() >= 0);
                                compoundToken = new DecompoundToken(morpheme.posTag, morpheme.surfaceForm, endOffset - morpheme.surfaceForm.length(), endOffset);
                            } else {
                                compoundToken = new DecompoundToken(morpheme.posTag, morpheme.surfaceForm, token2.getStartOffset(), token2.getEndOffset());
                            }
                            if (i2 == 0 && this.mode$38182e60 == DecompoundMode.MIXED$38182e60) {
                                compoundToken.setPositionIncrement(0);
                            }
                            ++posLen;
                            endOffset -= morpheme.surfaceForm.length();
                            this.pending.add(compoundToken);
                        }
                        if (this.mode$38182e60 == DecompoundMode.MIXED$38182e60) {
                            token2.setPositionLength(Math.max(1, posLen));
                            this.pending.add(token2);
                        }
                    }
                }
            }
            if (!this.discardPunctuation && backWordPos != backPos) {
                int offset = backPos - this.lastBackTracePos;
                int len = backWordPos - backPos;
                this.unkDictionary.lookupWordIds(this.characterDefinition.getCharacterClass(' '), this.wordIdRef);
                int n = backPos;
                DictionaryToken spaceToken = new DictionaryToken(Type.UNKNOWN, this.unkDictionary, this.wordIdRef.ints[this.wordIdRef.offset], fragment, offset, len, n, n + len);
                this.pending.add(spaceToken);
            }
            int n = backPos;
        }
        this.lastBackTracePos = endPos;
        this.buffer.freeBefore(endPos);
        this.positions.freeBefore((int)var1_2);
    }

    /*
     * WARNING - void declaration
     */
    final Dictionary getDict(Type type) {
        void var1_1;
        return this.dictionaryMap.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean shouldFilterToken(Token token) {
        void var1_1;
        return this.discardPunctuation && KoreanTokenizer.isPunctuation(token.getSurfaceForm()[var1_1.getOffset()]);
    }

    private static boolean isPunctuation(char ch) {
        char c = ch;
        return KoreanTokenizer.isPunctuation(c, Character.getType(c));
    }

    /*
     * WARNING - void declaration
     */
    private static boolean isPunctuation(char ch, int cid) {
        void var1_1;
        if (ch == '\u318d') {
            return true;
        }
        switch (var1_1) {
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                return true;
            }
        }
        return false;
    }

    private static boolean isCommonOrInherited(Character.UnicodeScript script) {
        Character.UnicodeScript unicodeScript;
        return script == Character.UnicodeScript.INHERITED || unicodeScript == Character.UnicodeScript.COMMON;
    }

    static final class WrappedPositionArray {
        private Position[] positions = new Position[8];
        private int nextWrite;
        private int nextPos;
        private int count;

        public WrappedPositionArray() {
            for (int i = 0; i < this.positions.length; ++i) {
                this.positions[i] = new Position();
            }
        }

        public final void reset() {
            --this.nextWrite;
            while (this.count > 0) {
                if (this.nextWrite == -1) {
                    this.nextWrite = this.positions.length - 1;
                }
                Position position = this.positions[this.nextWrite--];
                this.positions[this.nextWrite--].count = 0;
                --this.count;
            }
            this.nextWrite = 0;
            this.nextPos = 0;
            this.count = 0;
        }

        /*
         * WARNING - void declaration
         */
        public final Position get(int pos) {
            void var2_3;
            void var1_1;
            int n;
            Position[] newPositions;
            while (pos >= this.nextPos) {
                if (this.count == this.positions.length) {
                    newPositions = new Position[ArrayUtil.oversize(1 + this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
                    System.arraycopy(this.positions, this.nextWrite, newPositions, 0, this.positions.length - this.nextWrite);
                    System.arraycopy(this.positions, 0, newPositions, this.positions.length - this.nextWrite, this.nextWrite);
                    for (int i = this.positions.length; i < newPositions.length; ++i) {
                        newPositions[i] = new Position();
                    }
                    this.nextWrite = this.positions.length;
                    this.positions = newPositions;
                }
                if (this.nextWrite == this.positions.length) {
                    this.nextWrite = 0;
                }
                assert (this.positions[this.nextWrite].count == 0);
                ++this.nextWrite;
                ++this.nextPos;
                this.positions[this.nextWrite].pos = this.positions[this.nextWrite].pos;
                ++this.count;
            }
            if (!$assertionsDisabled) {
                n = pos;
                newPositions = this;
                if (!(n < newPositions.nextPos && n >= newPositions.nextPos - newPositions.count)) {
                    throw new AssertionError();
                }
            }
            n = pos;
            newPositions = this;
            if ((n = this.nextWrite - (newPositions.nextPos - n)) < 0) {
                n += newPositions.positions.length;
            }
            int index = n;
            assert (this.positions[index].pos == var1_1);
            return this.positions[var2_3];
        }

        public final int getNextPos() {
            return this.nextPos;
        }

        /*
         * WARNING - void declaration
         */
        public final void freeBefore(int pos) {
            void var1_1;
            int toFree = this.count - (this.nextPos - pos);
            assert (toFree >= 0);
            assert (toFree <= this.count);
            int index = this.nextWrite - this.count;
            if (index < 0) {
                index += this.positions.length;
            }
            for (int i = 0; i < toFree; ++i) {
                if (index == this.positions.length) {
                    index = 0;
                }
                Position position = this.positions[index];
                this.positions[index].count = 0;
                ++index;
            }
            this.count -= var1_1;
        }
    }

    static final class Position {
        int pos;
        int count;
        int[] costs = new int[8];
        int[] lastRightID = new int[8];
        int[] backPos = new int[8];
        int[] backWordPos = new int[8];
        int[] backIndex = new int[8];
        int[] backID = new int[8];
        Type[] backType = new Type[8];

        Position() {
        }

        /*
         * WARNING - void declaration
         */
        private void grow() {
            void var1_1;
            this.costs = ArrayUtil.grow(this.costs, 1 + this.count);
            this.lastRightID = ArrayUtil.grow(this.lastRightID, 1 + this.count);
            this.backPos = ArrayUtil.grow(this.backPos, 1 + this.count);
            this.backWordPos = ArrayUtil.grow(this.backWordPos, 1 + this.count);
            this.backIndex = ArrayUtil.grow(this.backIndex, 1 + this.count);
            this.backID = ArrayUtil.grow(this.backID, 1 + this.count);
            Type[] newBackType = new Type[this.backID.length];
            System.arraycopy(this.backType, 0, newBackType, 0, this.backType.length);
            this.backType = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void add(int cost, int lastRightID, int backPos, int backRPos, int backIndex, int backID, Type backType) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (this.count == this.costs.length) {
                this.grow();
            }
            this.costs[this.count] = var1_1;
            this.lastRightID[this.count] = var2_2;
            this.backPos[this.count] = var3_3;
            this.backWordPos[this.count] = backRPos;
            this.backIndex[this.count] = backIndex;
            this.backID[this.count] = backID;
            this.backType[this.count] = backType;
            ++this.count;
        }
    }

    public static final class DecompoundMode
    extends Enum<DecompoundMode> {
        public static final int NONE$38182e60 = 1;
        public static final int DISCARD$38182e60 = 2;
        public static final int MIXED$38182e60 = 3;

        static {
            int[] nArray = new int[]{1, 2, 3};
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type KNOWN = new Type();
        public static final /* enum */ Type UNKNOWN = new Type();
        public static final /* enum */ Type USER = new Type();

        static {
            Type[] typeArray = new Type[]{KNOWN, UNKNOWN, USER};
        }
    }
}

