/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.util;

import java.io.IOException;
import java.io.Reader;
import java.text.BreakIterator;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.util.CharArrayIterator;
import org.apache.lucene.util.AttributeFactory;

public abstract class SegmentingTokenizerBase
extends Tokenizer {
    protected final char[] buffer = new char[1024];
    private int length = 0;
    private int usableLength = 0;
    protected int offset = 0;
    private final BreakIterator iterator;
    private final CharArrayIterator wrapper = CharArrayIterator.newSentenceInstance();
    private final OffsetAttribute offsetAtt = this.addAttribute(OffsetAttribute.class);

    /*
     * WARNING - void declaration
     */
    public SegmentingTokenizerBase(AttributeFactory factory, BreakIterator iterator) {
        super((AttributeFactory)var1_1);
        void var2_2;
        void var1_1;
        this.iterator = var2_2;
    }

    @Override
    public final boolean incrementToken() throws IOException {
        block13: {
            if (this.length == 0 || !this.incrementWord()) {
                do {
                    int n;
                    int n2;
                    int n3;
                    int n4;
                    int n5;
                    boolean bl;
                    SegmentingTokenizerBase segmentingTokenizerBase;
                    block12: {
                        segmentingTokenizerBase = this;
                        if (segmentingTokenizerBase.length == 0) {
                            bl = false;
                        } else {
                            do {
                                if ((n5 = segmentingTokenizerBase.iterator.current()) == -1) {
                                    bl = false;
                                    break block12;
                                }
                                n4 = segmentingTokenizerBase.iterator.next();
                                if (n4 == -1) {
                                    bl = false;
                                    break block12;
                                }
                                segmentingTokenizerBase.setNextSentence(n5, n4);
                            } while (!segmentingTokenizerBase.incrementWord());
                            bl = true;
                        }
                    }
                    if (bl) break block13;
                    segmentingTokenizerBase = this;
                    segmentingTokenizerBase.offset += segmentingTokenizerBase.usableLength;
                    n5 = segmentingTokenizerBase.length - segmentingTokenizerBase.usableLength;
                    System.arraycopy(segmentingTokenizerBase.buffer, segmentingTokenizerBase.usableLength, segmentingTokenizerBase.buffer, 0, n5);
                    int n6 = n4 = 1024 - n5;
                    int n7 = n5;
                    char[] cArray = segmentingTokenizerBase.buffer;
                    Reader reader = segmentingTokenizerBase.input;
                    assert (n6 >= 0) : "length must not be negative: " + n6;
                    for (n2 = n6; n2 > 0; n2 -= n3) {
                        n3 = n6 - n2;
                        if (-1 == (n3 = reader.read(cArray, n7 + n3, n2))) break;
                    }
                    int n8 = segmentingTokenizerBase.length = (n = n6 - n2) < 0 ? n5 : n + n5;
                    if (n < n4) {
                        segmentingTokenizerBase.usableLength = segmentingTokenizerBase.length;
                    } else {
                        segmentingTokenizerBase.usableLength = segmentingTokenizerBase.findSafeEnd();
                        if (segmentingTokenizerBase.usableLength < 0) {
                            segmentingTokenizerBase.usableLength = segmentingTokenizerBase.length;
                        }
                    }
                    segmentingTokenizerBase.wrapper.setText(segmentingTokenizerBase.buffer, 0, Math.max(0, segmentingTokenizerBase.usableLength));
                    segmentingTokenizerBase.iterator.setText(segmentingTokenizerBase.wrapper);
                } while (this.length > 0);
                return false;
            }
        }
        return true;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.wrapper.setText(this.buffer, 0, 0);
        this.iterator.setText(this.wrapper);
        SegmentingTokenizerBase segmentingTokenizerBase = this;
        this.offset = 0;
        segmentingTokenizerBase.usableLength = 0;
        segmentingTokenizerBase.length = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void end() throws IOException {
        void var1_1;
        super.end();
        SegmentingTokenizerBase segmentingTokenizerBase = this;
        int finalOffset = segmentingTokenizerBase.correctOffset(segmentingTokenizerBase.length < 0 ? this.offset : this.offset + this.length);
        void v1 = var1_1;
        this.offsetAtt.setOffset((int)v1, (int)v1);
    }

    private int findSafeEnd() {
        for (int i = this.length - 1; i >= 0; --i) {
            boolean bl;
            char c = this.buffer[i];
            switch (c) {
                case '\n': 
                case '\r': 
                case '\u0085': 
                case '\u2028': 
                case '\u2029': {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl) continue;
            return i + 1;
        }
        return -1;
    }

    protected abstract void setNextSentence(int var1, int var2);

    protected abstract boolean incrementWord();
}

