/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.lucene.util.Attribute;
import org.apache.lucene.util.AttributeImpl;

public abstract class AttributeFactory {
    private static final MethodHandles.Lookup lookup = MethodHandles.publicLookup();
    private static final MethodType NO_ARG_CTOR = MethodType.methodType(Void.TYPE);
    private static final MethodType NO_ARG_RETURNING_ATTRIBUTEIMPL = MethodType.methodType(AttributeImpl.class);
    public static final AttributeFactory DEFAULT_ATTRIBUTE_FACTORY = new DefaultAttributeFactory();

    public abstract AttributeImpl createAttributeInstance(Class<? extends Attribute> var1) throws UndeclaredThrowableException;

    /*
     * WARNING - void declaration
     */
    static final MethodHandle findAttributeImplCtor(Class<? extends AttributeImpl> clazz) {
        try {
            return lookup.findConstructor(clazz, NO_ARG_CTOR).asType(NO_ARG_RETURNING_ATTRIBUTEIMPL);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            void var1_1;
            Class<? extends AttributeImpl> clazz2;
            throw new IllegalArgumentException("Cannot lookup accessible no-arg constructor for: " + clazz2.getName(), (Throwable)var1_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static <A extends AttributeImpl> AttributeFactory getStaticImplementation(AttributeFactory delegate, Class<A> clazz) {
        void var2_2;
        void var1_1;
        AttributeFactory attributeFactory;
        MethodHandle constr = AttributeFactory.findAttributeImplCtor(clazz);
        return new StaticImplementationAttributeFactory<A>(attributeFactory, (Class)var1_1, (MethodHandle)var2_2){
            private /* synthetic */ MethodHandle val$constr;
            {
                void var2_2;
                void var1_1;
                this.val$constr = methodHandle;
                super((AttributeFactory)var1_1, var2_2);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected final A createInstance() {
                try {
                    return this.val$constr.invokeExact();
                }
                catch (Error | RuntimeException throwable) {
                    Throwable throwable2 = throwable;
                    throw throwable;
                }
                catch (Throwable e) {
                    void var1_2;
                    throw new UndeclaredThrowableException((Throwable)var1_2);
                }
            }
        };
    }

    public static abstract class StaticImplementationAttributeFactory<A extends AttributeImpl>
    extends AttributeFactory {
        private final AttributeFactory delegate;
        private final Class<A> clazz;

        /*
         * WARNING - void declaration
         */
        public StaticImplementationAttributeFactory(AttributeFactory delegate, Class<A> clazz) {
            void var2_2;
            void var1_1;
            this.delegate = var1_1;
            this.clazz = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
            void var1_1;
            if (attClass.isAssignableFrom(this.clazz)) {
                return this.createInstance();
            }
            return this.delegate.createAttributeInstance((Class<? extends Attribute>)var1_1);
        }

        protected abstract A createInstance();

        /*
         * WARNING - void declaration
         */
        public boolean equals(Object other) {
            void var1_1;
            if (this == other) {
                return true;
            }
            if (other == null || other.getClass() != this.getClass()) {
                return false;
            }
            StaticImplementationAttributeFactory af = (StaticImplementationAttributeFactory)other;
            return this.delegate.equals(af.delegate) && this.clazz == var1_1.clazz;
        }

        public int hashCode() {
            return 31 * this.delegate.hashCode() + this.clazz.hashCode();
        }
    }

    static final class DefaultAttributeFactory
    extends AttributeFactory {
        private final ClassValue<MethodHandle> constructors = new ClassValue<MethodHandle>(this){
            private /* synthetic */ DefaultAttributeFactory this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }
        };

        DefaultAttributeFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final AttributeImpl createAttributeInstance(Class<? extends Attribute> attClass) {
            try {
                return this.constructors.get((Class<?>)attClass).invokeExact();
            }
            catch (Error | RuntimeException throwable) {
                attClass = throwable;
                throw throwable;
            }
            catch (Throwable e) {
                void var1_2;
                throw new UndeclaredThrowableException((Throwable)var1_2);
            }
        }

        private static Class<? extends AttributeImpl> findImplClass(Class<? extends Attribute> attClass) {
            try {
                return Class.forName(attClass.getName() + "Impl", true, attClass.getClassLoader()).asSubclass(AttributeImpl.class);
            }
            catch (ClassNotFoundException classNotFoundException) {
                Class<? extends Attribute> clazz;
                throw new IllegalArgumentException("Cannot find implementing class for: " + clazz.getName());
            }
        }
    }
}

