/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

public final class Version {
    private static Version LUCENE_8_8_0;
    public static final Version LATEST;
    private int major;
    private int minor;
    private int bugfix;
    private int prerelease;
    private final int encodedValue;

    /*
     * WARNING - void declaration
     */
    private Version(int major, int minor, int bugfix) {
        this((int)var1_1, (int)var2_2, (int)var3_3, 0);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private Version(int major, int minor, int bugfix, int prerelease) {
        void var3_4;
        void var2_3;
        void var1_1;
        this.major = major;
        this.minor = minor;
        this.bugfix = bugfix;
        this.prerelease = 0;
        if (major > 255 || major < 0) {
            throw new IllegalArgumentException("Illegal major version: " + major);
        }
        if (minor > 255 || minor < 0) {
            throw new IllegalArgumentException("Illegal minor version: " + minor);
        }
        if (bugfix > 255 || bugfix < 0) {
            throw new IllegalArgumentException("Illegal bugfix version: " + bugfix);
        }
        this.encodedValue = var1_1 << 18 | var2_3 << 10 | var3_4 << 2;
        if (!$assertionsDisabled) {
            Version version = this;
            assert (version.major == (version.encodedValue >>> 18 & 0xFF));
            assert (version.minor == (version.encodedValue >>> 10 & 0xFF));
            assert (version.bugfix == (version.encodedValue >>> 2 & 0xFF));
            assert (version.prerelease == (version.encodedValue & 3));
        }
    }

    public final String toString() {
        if (this.prerelease == 0) {
            return this.major + "." + this.minor + "." + this.bugfix;
        }
        return this.major + "." + this.minor + "." + this.bugfix + "." + this.prerelease;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object o) {
        void var1_1;
        return o != null && o instanceof Version && ((Version)var1_1).encodedValue == this.encodedValue;
    }

    public final int hashCode() {
        return this.encodedValue;
    }

    static {
        new Version(7, 0, 0);
        new Version(7, 0, 1);
        new Version(7, 1, 0);
        new Version(7, 2, 0);
        new Version(7, 2, 1);
        new Version(7, 3, 0);
        new Version(7, 3, 1);
        new Version(7, 4, 0);
        new Version(7, 5, 0);
        new Version(7, 6, 0);
        new Version(7, 7, 0);
        new Version(7, 7, 1);
        new Version(7, 7, 2);
        new Version(7, 7, 3);
        new Version(7, 8, 0);
        new Version(8, 0, 0);
        new Version(8, 1, 0);
        new Version(8, 1, 1);
        new Version(8, 2, 0);
        new Version(8, 3, 0);
        new Version(8, 3, 1);
        new Version(8, 4, 0);
        new Version(8, 4, 1);
        new Version(8, 5, 0);
        new Version(8, 5, 1);
        new Version(8, 5, 2);
        new Version(8, 6, 0);
        new Version(8, 6, 1);
        new Version(8, 6, 2);
        new Version(8, 6, 3);
        new Version(8, 7, 0);
        LATEST = LUCENE_8_8_0 = new Version(8, 8, 0);
    }
}

