/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util.fst;

import java.io.IOException;
import org.apache.lucene.util.fst.FST;

class BitTableUtil {
    BitTableUtil() {
    }

    /*
     * WARNING - void declaration
     */
    static boolean isBitSet(int bitIndex, FST.BytesReader reader) throws IOException {
        int n;
        void var1_1;
        assert (bitIndex >= 0) : "bitIndex=" + bitIndex;
        reader.skipBytes(bitIndex >> 3);
        return (BitTableUtil.readByte((FST.BytesReader)var1_1) & 1L << (n & 7)) != 0L;
    }

    /*
     * WARNING - void declaration
     */
    static int countBits(int bitTableBytes, FST.BytesReader reader) throws IOException {
        void var2_2;
        int n;
        assert (bitTableBytes >= 0) : "bitTableBytes=" + bitTableBytes;
        int bitCount = 0;
        for (int i = bitTableBytes >> 3; i > 0; --i) {
            bitCount += Long.bitCount(BitTableUtil.read8Bytes(reader));
        }
        int numRemainingBytes = n & 7;
        if (numRemainingBytes != 0) {
            void var1_1;
            void var3_3;
            bitCount += Long.bitCount(BitTableUtil.readUpTo8Bytes((int)var3_3, (FST.BytesReader)var1_1));
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int countBitsUpTo(int bitIndex, FST.BytesReader reader) throws IOException {
        void var2_2;
        assert (bitIndex >= 0) : "bitIndex=" + bitIndex;
        int bitCount = 0;
        for (int i = bitIndex >> 6; i > 0; --i) {
            bitCount += Long.bitCount(BitTableUtil.read8Bytes(reader));
        }
        int remainingBits = bitIndex & 0x3F;
        if (remainingBits != 0) {
            void var1_1;
            void var3_3;
            int n;
            int numRemainingBytes = remainingBits + 7 >> 3;
            long mask = (1L << n) - 1L;
            bitCount += Long.bitCount(BitTableUtil.readUpTo8Bytes((int)var3_3, (FST.BytesReader)var1_1) & mask);
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int nextBitSet(int bitIndex, int bitTableBytes, FST.BytesReader reader) throws IOException {
        void var3_3;
        int n;
        int i;
        assert (bitIndex >= -1 && bitIndex < bitTableBytes << 3) : "bitIndex=" + bitIndex + " bitTableBytes=" + bitTableBytes;
        int byteIndex = bitIndex / 8;
        int mask = -1 << (bitIndex + 1 & 7);
        if (mask == -1 && bitIndex != -1) {
            reader.skipBytes(byteIndex + 1);
            i = 0;
        } else {
            reader.skipBytes(byteIndex);
            i = reader.readByte() & 0xFF & mask;
        }
        while (i == 0) {
            if (++byteIndex == bitTableBytes) {
                return -1;
            }
            i = reader.readByte() & 0xFF;
        }
        return Integer.numberOfTrailingZeros(n) + (var3_3 << 3);
    }

    private static long readByte(FST.BytesReader reader) throws IOException {
        return (long)reader.readByte() & 0xFFL;
    }

    /*
     * WARNING - void declaration
     */
    private static long readUpTo8Bytes(int numBytes, FST.BytesReader reader) throws IOException {
        void var2_2;
        assert (numBytes > 0 && numBytes <= 8) : "numBytes=" + numBytes;
        long l = BitTableUtil.readByte(reader);
        int shift = 0;
        while (--numBytes != 0) {
            l |= BitTableUtil.readByte(reader) << (shift += 8);
        }
        return (long)var2_2;
    }

    private static long read8Bytes(FST.BytesReader reader) throws IOException {
        FST.BytesReader bytesReader;
        return BitTableUtil.readByte(reader) | BitTableUtil.readByte(reader) << 8 | BitTableUtil.readByte(reader) << 16 | BitTableUtil.readByte(reader) << 24 | BitTableUtil.readByte(reader) << 32 | BitTableUtil.readByte(reader) << 40 | BitTableUtil.readByte(reader) << 48 | BitTableUtil.readByte(bytesReader) << 56;
    }
}

