/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.impl.NoOpLog;

public class LogSource {
    protected static Hashtable logs = new Hashtable();
    protected static boolean log4jIsAvailable = false;
    protected static boolean jdk14IsAvailable = false;
    protected static Constructor logImplctor = null;

    private LogSource() {
    }

    public static void setLogImplementation(String classname) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException, ClassNotFoundException {
        try {
            Class<?> logclass = Class.forName(classname);
            Class[] argtypes = new Class[]{"".getClass()};
            logImplctor = logclass.getConstructor(argtypes);
        }
        catch (Throwable t2) {
            logImplctor = null;
        }
    }

    public static void setLogImplementation(Class logclass) throws LinkageError, ExceptionInInitializerError, NoSuchMethodException, SecurityException {
        Class[] argtypes = new Class[]{"".getClass()};
        logImplctor = logclass.getConstructor(argtypes);
    }

    public static Log getInstance(String name) {
        Log log3 = (Log)logs.get(name);
        if (null == log3) {
            log3 = LogSource.makeNewLogInstance(name);
            logs.put(name, log3);
        }
        return log3;
    }

    public static Log getInstance(Class clazz) {
        return LogSource.getInstance(clazz.getName());
    }

    public static Log makeNewLogInstance(String name) {
        Log log3 = null;
        try {
            Object[] args2 = new Object[]{name};
            log3 = (Log)logImplctor.newInstance(args2);
        }
        catch (Throwable t2) {
            log3 = null;
        }
        if (null == log3) {
            log3 = new NoOpLog(name);
        }
        return log3;
    }

    public static String[] getLogNames() {
        return logs.keySet().toArray(new String[logs.size()]);
    }

    static {
        try {
            log4jIsAvailable = null != Class.forName("org.apache.log4j.Logger");
        }
        catch (Throwable t2) {
            log4jIsAvailable = false;
        }
        try {
            jdk14IsAvailable = null != Class.forName("java.util.logging.Logger") && null != Class.forName("org.apache.commons.logging.impl.Jdk14Logger");
        }
        catch (Throwable t3) {
            jdk14IsAvailable = false;
        }
        String name = null;
        try {
            name = System.getProperty("org.apache.commons.logging.log");
            if (name == null) {
                name = System.getProperty("org.apache.commons.logging.Log");
            }
        }
        catch (Throwable t4) {
            // empty catch block
        }
        if (name != null) {
            try {
                LogSource.setLogImplementation(name);
            }
            catch (Throwable t5) {
                try {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable u) {}
            }
        } else {
            try {
                if (log4jIsAvailable) {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.Log4JLogger");
                } else if (jdk14IsAvailable) {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.Jdk14Logger");
                } else {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
            }
            catch (Throwable t6) {
                try {
                    LogSource.setLogImplementation("org.apache.commons.logging.impl.NoOpLog");
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }
}

