/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.ExponentialDistribution;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.util.FastMath;

public class ExponentialDistributionImpl
extends AbstractContinuousDistribution
implements ExponentialDistribution,
Serializable {
    public static final double DEFAULT_INVERSE_ABSOLUTE_ACCURACY = 1.0E-9;
    private static final long serialVersionUID = 2401296428283614780L;
    private double mean;
    private final double solverAbsoluteAccuracy;

    public ExponentialDistributionImpl(double mean2) {
        this(mean2, 1.0E-9);
    }

    public ExponentialDistributionImpl(double mean2, double inverseCumAccuracy) {
        this.setMeanInternal(mean2);
        this.solverAbsoluteAccuracy = inverseCumAccuracy;
    }

    @Deprecated
    public void setMean(double mean2) {
        this.setMeanInternal(mean2);
    }

    private void setMeanInternal(double newMean) {
        if (newMean <= 0.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.NOT_POSITIVE_MEAN, newMean);
        }
        this.mean = newMean;
    }

    public double getMean() {
        return this.mean;
    }

    @Deprecated
    public double density(Double x) {
        return this.density((double)x);
    }

    public double density(double x) {
        if (x < 0.0) {
            return 0.0;
        }
        return FastMath.exp(-x / this.mean) / this.mean;
    }

    public double cumulativeProbability(double x) throws MathException {
        double ret = x <= 0.0 ? 0.0 : 1.0 - FastMath.exp(-x / this.mean);
        return ret;
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        if (p < 0.0 || p > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.OUT_OF_RANGE_SIMPLE, p, 0.0, 1.0);
        }
        double ret = p == 1.0 ? Double.POSITIVE_INFINITY : -this.mean * FastMath.log(1.0 - p);
        return ret;
    }

    public double sample() throws MathException {
        return this.randomData.nextExponential(this.mean);
    }

    protected double getDomainLowerBound(double p) {
        return 0.0;
    }

    protected double getDomainUpperBound(double p) {
        if (p < 0.5) {
            return this.mean;
        }
        return Double.MAX_VALUE;
    }

    protected double getInitialDomain(double p) {
        if (p < 0.5) {
            return this.mean * 0.5;
        }
        return this.mean;
    }

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }

    public double getSupportLowerBound() {
        return 0.0;
    }

    public double getSupportUpperBound() {
        return Double.POSITIVE_INFINITY;
    }

    public double getNumericalMean() {
        return this.getMean();
    }

    public double getNumericalVariance() {
        double m = this.getMean();
        return m * m;
    }
}

