/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.exception.util.LocalizedFormats;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecomposition;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.linear.SingularMatrixException;
import org.apache.commons.math.util.FastMath;

public class LUDecompositionImpl
implements LUDecomposition {
    private static final double DEFAULT_TOO_SMALL = 1.0E-11;
    private double[][] lu;
    private int[] pivot;
    private boolean even;
    private boolean singular;
    private RealMatrix cachedL;
    private RealMatrix cachedU;
    private RealMatrix cachedP;

    public LUDecompositionImpl(RealMatrix matrix2) throws InvalidMatrixException {
        this(matrix2, 1.0E-11);
    }

    public LUDecompositionImpl(RealMatrix matrix2, double singularityThreshold) throws NonSquareMatrixException {
        if (!matrix2.isSquare()) {
            throw new NonSquareMatrixException(matrix2.getRowDimension(), matrix2.getColumnDimension());
        }
        int m = matrix2.getColumnDimension();
        this.lu = matrix2.getData();
        this.pivot = new int[m];
        this.cachedL = null;
        this.cachedU = null;
        this.cachedP = null;
        for (int row2 = 0; row2 < m; ++row2) {
            this.pivot[row2] = row2;
        }
        this.even = true;
        this.singular = false;
        for (int col2 = 0; col2 < m; ++col2) {
            double sum2 = 0.0;
            for (int row3 = 0; row3 < col2; ++row3) {
                double[] luRow = this.lu[row3];
                sum2 = luRow[col2];
                for (int i = 0; i < row3; ++i) {
                    sum2 -= luRow[i] * this.lu[i][col2];
                }
                luRow[col2] = sum2;
            }
            int max2 = col2;
            double largest = Double.NEGATIVE_INFINITY;
            for (int row4 = col2; row4 < m; ++row4) {
                double[] luRow = this.lu[row4];
                sum2 = luRow[col2];
                for (int i = 0; i < col2; ++i) {
                    sum2 -= luRow[i] * this.lu[i][col2];
                }
                luRow[col2] = sum2;
                if (!(FastMath.abs(sum2) > largest)) continue;
                largest = FastMath.abs(sum2);
                max2 = row4;
            }
            if (FastMath.abs(this.lu[max2][col2]) < singularityThreshold) {
                this.singular = true;
                return;
            }
            if (max2 != col2) {
                double tmp = 0.0;
                double[] luMax = this.lu[max2];
                double[] luCol = this.lu[col2];
                for (int i = 0; i < m; ++i) {
                    tmp = luMax[i];
                    luMax[i] = luCol[i];
                    luCol[i] = tmp;
                }
                int temp = this.pivot[max2];
                this.pivot[max2] = this.pivot[col2];
                this.pivot[col2] = temp;
                this.even = !this.even;
            }
            double luDiag = this.lu[col2][col2];
            for (int row5 = col2 + 1; row5 < m; ++row5) {
                double[] dArray = this.lu[row5];
                int n = col2;
                dArray[n] = dArray[n] / luDiag;
            }
        }
    }

    public RealMatrix getL() {
        if (this.cachedL == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedL = MatrixUtils.createRealMatrix(m, m);
            for (int i = 0; i < m; ++i) {
                double[] luI = this.lu[i];
                for (int j = 0; j < i; ++j) {
                    this.cachedL.setEntry(i, j, luI[j]);
                }
                this.cachedL.setEntry(i, i, 1.0);
            }
        }
        return this.cachedL;
    }

    public RealMatrix getU() {
        if (this.cachedU == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedU = MatrixUtils.createRealMatrix(m, m);
            for (int i = 0; i < m; ++i) {
                double[] luI = this.lu[i];
                for (int j = i; j < m; ++j) {
                    this.cachedU.setEntry(i, j, luI[j]);
                }
            }
        }
        return this.cachedU;
    }

    public RealMatrix getP() {
        if (this.cachedP == null && !this.singular) {
            int m = this.pivot.length;
            this.cachedP = MatrixUtils.createRealMatrix(m, m);
            for (int i = 0; i < m; ++i) {
                this.cachedP.setEntry(i, this.pivot[i], 1.0);
            }
        }
        return this.cachedP;
    }

    public int[] getPivot() {
        return (int[])this.pivot.clone();
    }

    public double getDeterminant() {
        if (this.singular) {
            return 0.0;
        }
        int m = this.pivot.length;
        double determinant = this.even ? 1.0 : -1.0;
        for (int i = 0; i < m; ++i) {
            determinant *= this.lu[i][i];
        }
        return determinant;
    }

    public DecompositionSolver getSolver() {
        return new Solver(this.lu, this.pivot, this.singular);
    }

    private static class Solver
    implements DecompositionSolver {
        private final double[][] lu;
        private final int[] pivot;
        private final boolean singular;

        private Solver(double[][] lu, int[] pivot, boolean singular) {
            this.lu = lu;
            this.pivot = pivot;
            this.singular = singular;
        }

        public boolean isNonSingular() {
            return !this.singular;
        }

        public double[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
            int i;
            double bpCol;
            int col2;
            int m = this.pivot.length;
            if (b.length != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.length, m);
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            double[] bp = new double[m];
            for (int row2 = 0; row2 < m; ++row2) {
                bp[row2] = b[this.pivot[row2]];
            }
            for (col2 = 0; col2 < m; ++col2) {
                bpCol = bp[col2];
                for (i = col2 + 1; i < m; ++i) {
                    int n = i;
                    bp[n] = bp[n] - bpCol * this.lu[i][col2];
                }
            }
            for (col2 = m - 1; col2 >= 0; --col2) {
                int n = col2;
                bp[n] = bp[n] / this.lu[col2][col2];
                bpCol = bp[col2];
                for (i = 0; i < col2; ++i) {
                    int n2 = i;
                    bp[n2] = bp[n2] - bpCol * this.lu[i][col2];
                }
            }
            return bp;
        }

        public RealVector solve(RealVector b) throws IllegalArgumentException, InvalidMatrixException {
            try {
                return this.solve((ArrayRealVector)b);
            }
            catch (ClassCastException cce) {
                int i;
                double bpCol;
                int col2;
                int m = this.pivot.length;
                if (b.getDimension() != m) {
                    throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.VECTOR_LENGTH_MISMATCH, b.getDimension(), m);
                }
                if (this.singular) {
                    throw new SingularMatrixException();
                }
                double[] bp = new double[m];
                for (int row2 = 0; row2 < m; ++row2) {
                    bp[row2] = b.getEntry(this.pivot[row2]);
                }
                for (col2 = 0; col2 < m; ++col2) {
                    bpCol = bp[col2];
                    for (i = col2 + 1; i < m; ++i) {
                        int n = i;
                        bp[n] = bp[n] - bpCol * this.lu[i][col2];
                    }
                }
                for (col2 = m - 1; col2 >= 0; --col2) {
                    int n = col2;
                    bp[n] = bp[n] / this.lu[col2][col2];
                    bpCol = bp[col2];
                    for (i = 0; i < col2; ++i) {
                        int n2 = i;
                        bp[n2] = bp[n2] - bpCol * this.lu[i][col2];
                    }
                }
                return new ArrayRealVector(bp, false);
            }
        }

        public ArrayRealVector solve(ArrayRealVector b) throws IllegalArgumentException, InvalidMatrixException {
            return new ArrayRealVector(this.solve(b.getDataRef()), false);
        }

        public RealMatrix solve(RealMatrix b) throws IllegalArgumentException, InvalidMatrixException {
            double[] bpCol;
            int col2;
            int m = this.pivot.length;
            if (b.getRowDimension() != m) {
                throw MathRuntimeException.createIllegalArgumentException(LocalizedFormats.DIMENSIONS_MISMATCH_2x2, b.getRowDimension(), b.getColumnDimension(), m, "n");
            }
            if (this.singular) {
                throw new SingularMatrixException();
            }
            int nColB = b.getColumnDimension();
            double[][] bp = new double[m][nColB];
            for (int row2 = 0; row2 < m; ++row2) {
                double[] bpRow = bp[row2];
                int pRow = this.pivot[row2];
                for (int col3 = 0; col3 < nColB; ++col3) {
                    bpRow[col3] = b.getEntry(pRow, col3);
                }
            }
            for (col2 = 0; col2 < m; ++col2) {
                bpCol = bp[col2];
                for (int i = col2 + 1; i < m; ++i) {
                    double[] bpI = bp[i];
                    double luICol = this.lu[i][col2];
                    for (int j = 0; j < nColB; ++j) {
                        int n = j;
                        bpI[n] = bpI[n] - bpCol[j] * luICol;
                    }
                }
            }
            for (col2 = m - 1; col2 >= 0; --col2) {
                bpCol = bp[col2];
                double luDiag = this.lu[col2][col2];
                int j = 0;
                while (j < nColB) {
                    int n = j++;
                    bpCol[n] = bpCol[n] / luDiag;
                }
                for (int i = 0; i < col2; ++i) {
                    double[] bpI = bp[i];
                    double luICol = this.lu[i][col2];
                    for (int j2 = 0; j2 < nColB; ++j2) {
                        int n = j2;
                        bpI[n] = bpI[n] - bpCol[j2] * luICol;
                    }
                }
            }
            return new Array2DRowRealMatrix(bp, false);
        }

        public RealMatrix getInverse() throws InvalidMatrixException {
            return this.solve(MatrixUtils.createRealIdentityMatrix(this.pivot.length));
        }
    }
}

