/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.fitting;

import java.io.Serializable;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.exception.DimensionMismatchException;
import org.apache.commons.math.exception.NullArgumentException;
import org.apache.commons.math.exception.ZeroException;
import org.apache.commons.math.exception.util.LocalizedFormats;

public class GaussianDerivativeFunction
implements UnivariateRealFunction,
Serializable {
    private static final long serialVersionUID = -6500229089670174766L;
    private final double b;
    private final double c;
    private final double d2;

    public GaussianDerivativeFunction(double b, double c2, double d) {
        if (d == 0.0) {
            throw new ZeroException();
        }
        this.b = b;
        this.c = c2;
        this.d2 = d * d;
    }

    public GaussianDerivativeFunction(double[] parameters) {
        if (parameters == null) {
            throw new NullArgumentException(LocalizedFormats.INPUT_ARRAY);
        }
        if (parameters.length != 3) {
            throw new DimensionMismatchException(3, parameters.length);
        }
        if (parameters[2] == 0.0) {
            throw new ZeroException();
        }
        this.b = parameters[0];
        this.c = parameters[1];
        this.d2 = parameters[2] * parameters[2];
    }

    public double value(double x) {
        double xMc = x - this.c;
        return -this.b / this.d2 * xMc * Math.exp(-(xMc * xMc) / (2.0 * this.d2));
    }
}

