/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.tar;

final class TarUtils {
    private TarUtils() {
    }

    public static int getCheckSumOctalBytes(long value, byte[] buf, int offset, int length2) {
        TarUtils.getOctalBytes(value, buf, offset, length2);
        buf[offset + length2 - 1] = 32;
        buf[offset + length2 - 2] = 0;
        return offset + length2;
    }

    public static int getLongOctalBytes(long value, byte[] buf, int offset, int length2) {
        byte[] temp = new byte[length2 + 1];
        TarUtils.getOctalBytes(value, temp, 0, length2 + 1);
        System.arraycopy(temp, 0, buf, offset, length2);
        return offset + length2;
    }

    public static int getNameBytes(StringBuffer name, byte[] buffer, int offset, int length2) {
        int i;
        for (i = 0; i < length2 && i < name.length(); ++i) {
            buffer[offset + i] = (byte)name.charAt(i);
        }
        while (i < length2) {
            buffer[offset + i] = 0;
            ++i;
        }
        return offset + length2;
    }

    public static int getOctalBytes(long value, byte[] buffer, int offset, int length2) {
        int idx = length2 - 1;
        buffer[offset + idx] = 0;
        buffer[offset + --idx] = 32;
        --idx;
        if (value == 0L) {
            buffer[offset + idx] = 48;
            --idx;
        } else {
            for (long val = value; idx >= 0 && val > 0L; val >>= 3, --idx) {
                buffer[offset + idx] = (byte)(48 + (byte)(val & 7L));
            }
        }
        while (idx >= 0) {
            buffer[offset + idx] = 32;
            --idx;
        }
        return offset + length2;
    }

    public static long computeCheckSum(byte[] buffer) {
        long sum2 = 0L;
        for (int i = 0; i < buffer.length; ++i) {
            sum2 += (long)(0xFF & buffer[i]);
        }
        return sum2;
    }

    public static StringBuffer parseName(byte[] header, int offset, int length2) {
        StringBuffer result = new StringBuffer(length2);
        int end = offset + length2;
        for (int i = offset; i < end && header[i] != 0; ++i) {
            result.append((char)header[i]);
        }
        return result;
    }

    public static long parseOctal(byte[] header, int offset, int length2) {
        long result = 0L;
        boolean stillPadding = true;
        int end = offset + length2;
        for (int i = offset; i < end && header[i] != 0; ++i) {
            if (header[i] == 32 || header[i] == 48) {
                if (stillPadding) continue;
                if (header[i] == 32) break;
            }
            stillPadding = false;
            result = (result << 3) + (long)(header[i] - 48);
        }
        return result;
    }
}

