/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.svn.svnexe.command.add;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.add.AbstractAddCommand;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.svn.command.SvnCommand;
import org.apache.maven.scm.provider.svn.svnexe.command.SvnCommandLineUtils;
import org.apache.maven.scm.provider.svn.svnexe.command.add.SvnAddConsumer;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;

public class SvnAddCommand
extends AbstractAddCommand
implements SvnCommand {
    protected ScmResult executeAddCommand(ScmProviderRepository repository, ScmFileSet fileSet, String message, boolean binary) throws ScmException {
        int exitCode;
        if (binary) {
            throw new ScmException("This provider does not yet support binary files");
        }
        if (fileSet.getFiles().length == 0) {
            throw new ScmException("You must provide at least one file/directory to add");
        }
        Commandline cl = SvnAddCommand.createCommandLine(fileSet.getBasedir(), fileSet.getFileList());
        SvnAddConsumer consumer = new SvnAddConsumer(this.getLogger());
        CommandLineUtils.StringStreamConsumer stderr2 = new CommandLineUtils.StringStreamConsumer();
        if (this.getLogger().isInfoEnabled()) {
            this.getLogger().info("Executing: " + SvnCommandLineUtils.cryptPassword(cl));
            this.getLogger().info("Working directory: " + cl.getWorkingDirectory().getAbsolutePath());
        }
        try {
            exitCode = SvnCommandLineUtils.execute(cl, consumer, stderr2, this.getLogger());
        }
        catch (CommandLineException ex) {
            throw new ScmException("Error while executing command.", ex);
        }
        if (exitCode != 0) {
            return new AddScmResult(cl.toString(), "The svn command failed.", stderr2.getOutput(), false);
        }
        return new AddScmResult(cl.toString(), consumer.getAddedFiles());
    }

    private static Commandline createCommandLine(File workingDirectory, List files2) throws ScmException {
        Commandline cl = new Commandline();
        cl.setExecutable("svn");
        cl.setWorkingDirectory(workingDirectory.getAbsolutePath());
        cl.createArg().setValue("add");
        cl.createArg().setValue("--non-recursive");
        try {
            SvnCommandLineUtils.addTarget(cl, files2);
        }
        catch (IOException e) {
            throw new ScmException("Can't create the targets file", e);
        }
        return cl;
    }
}

