/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac;

import org.renjin.compiler.ir.tac.expressions.Expression;
import org.renjin.compiler.ir.tac.expressions.SimpleExpression;
import org.renjin.sexp.Null;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;

public class IRArgument {
    private String name;
    private Expression expression;

    public IRArgument(String name, Expression expression2) {
        this.name = name;
        this.expression = expression2;
    }

    public IRArgument(SEXP name, SimpleExpression expression2) {
        if (name == Null.INSTANCE) {
            this.name = null;
        } else if (name instanceof Symbol) {
            this.name = ((Symbol)name).getPrintName();
        } else {
            throw new IllegalArgumentException("name: " + name);
        }
        this.expression = expression2;
    }

    public IRArgument(Expression expression2) {
        this.name = null;
        this.expression = expression2;
    }

    public boolean isNamed() {
        return this.name != null;
    }

    public String getName() {
        return this.name;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public void setExpression(Expression expression2) {
        this.expression = expression2;
    }

    public static boolean anyNamed(Iterable<IRArgument> arguments) {
        for (IRArgument argument : arguments) {
            if (!argument.isNamed()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.isNamed()) {
            return this.name + " = " + this.expression;
        }
        return this.expression.toString();
    }
}

