/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.compiler.ir.tac;

import java.util.Map;
import org.renjin.compiler.NotCompilableException;
import org.renjin.compiler.ir.exception.InvalidSyntaxException;
import org.renjin.eval.Context;
import org.renjin.packaging.SerializedPromise;
import org.renjin.repackaged.guava.collect.Maps;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class RuntimeState {
    private Context context;
    private Environment rho;
    private Map<Symbol, Function> resolvedFunctions = Maps.newHashMap();

    public RuntimeState(Context context, Environment rho) {
        this.context = context;
        this.rho = rho;
    }

    public RuntimeState(RuntimeState parentState, Environment enclosingEnvironment) {
        this(parentState.context, enclosingEnvironment);
    }

    public PairList getEllipsesVariable() {
        SEXP ellipses = this.rho.getVariable(Symbols.ELLIPSES);
        if (ellipses == Symbol.UNBOUND_VALUE) {
            throw new InvalidSyntaxException("'...' used in an incorrect context.");
        }
        return (PairList)ellipses;
    }

    public SEXP findVariable(Symbol name) {
        SEXP value = this.rho.findVariable(name);
        if (value instanceof Promise) {
            Promise promisedValue = (Promise)value;
            if (promisedValue.isEvaluated()) {
                value = promisedValue.force(this.context);
            } else {
                throw new NotCompilableException(name, "Unevaluated promise encountered");
            }
        }
        return value;
    }

    public Function findFunction(Symbol functionName) {
        Function f = this.findFunctionIfExists(functionName);
        if (f != null) {
            return f;
        }
        throw new NotCompilableException(functionName, "Could not find function " + functionName);
    }

    public Function findFunctionIfExists(Symbol functionName) {
        if (this.resolvedFunctions.containsKey(functionName)) {
            return this.resolvedFunctions.get(functionName);
        }
        for (Environment environment2 = this.rho; environment2 != Environment.EMPTY; environment2 = environment2.getParent()) {
            Function f = this.isFunction(functionName, environment2.getVariable(functionName));
            if (f == null) continue;
            this.resolvedFunctions.put(functionName, f);
            return f;
        }
        return null;
    }

    private Function isFunction(Symbol functionName, SEXP exp2) {
        if (exp2 instanceof Function) {
            return (Function)exp2;
        }
        if (exp2 instanceof SerializedPromise) {
            return this.isFunction(functionName, exp2.force(this.context));
        }
        if (exp2 instanceof Promise) {
            Promise promise = (Promise)exp2;
            if (promise.isEvaluated()) {
                return this.isFunction(functionName, promise.getValue());
            }
            throw new NotCompilableException(functionName, "Symbol " + functionName + " cannot be resolved to a function " + " an enclosing environment has a binding of the same name to an unevaluated promise");
        }
        return null;
    }

    public Map<Symbol, Function> getResolvedFunctions() {
        return this.resolvedFunctions;
    }
}

