/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import org.renjin.gcc.runtime.Builtins;
import org.renjin.gcc.runtime.BytePtr;
import org.renjin.gcc.runtime.DoublePtr;
import org.renjin.gcc.runtime.Mathlib;
import org.renjin.gcc.runtime.Stdlib;
import org.renjin.nmath.dnorm;
import org.renjin.nmath.dpois;
import org.renjin.nmath.fmax2;
import org.renjin.nmath.lgamma;
import org.renjin.nmath.pnorm;

public class pgamma {
    public static double M_cutoff;
    public static double scalefactor;
    public static double[] $ppois_asymp$coefs_b;
    public static double[] $ppois_asymp$coefs_a;
    public static double[] $lgamma1p$coeffs;
    public static double $log1pmx$tol_logcf;
    public static double $log1pmx$two;
    public static double $log1pmx$minLog1Value;

    private pgamma() {
    }

    public static double pgamma(double d, double d2, double d3, int n, int n2) {
        double d4;
        if (Builtins.__isnan(d) != 0 || Builtins.__isnan(d2) != 0 || Builtins.__isnan(d3) != 0) {
            d4 = d + d2 + d3;
        } else if (d2 < 0.0 || d3 <= 0.0) {
            d4 = 0.0 / 0.0;
        } else if (Builtins.__isnan(d /= d3) != 0) {
            d4 = d;
        } else if (d2 == 0.0) {
            double iftmp$0;
            if (d <= 0.0) {
                double iftmp$1;
                if (n != 0) {
                    double iftmp$2 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$1 = iftmp$2;
                } else {
                    double iftmp$3 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$1 = iftmp$3;
                }
                iftmp$0 = iftmp$1;
            } else {
                double iftmp$4;
                if (n != 0) {
                    double iftmp$5 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$4 = iftmp$5;
                } else {
                    double iftmp$6 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$4 = iftmp$6;
                }
                iftmp$0 = iftmp$4;
            }
            d4 = iftmp$0;
        } else {
            d4 = pgamma.Rf_pgamma_raw(d, d2, n, n2);
        }
        return d4;
    }

    public static double Rf_pgamma_raw(double d, double d2, int n, int n2) {
        double d3;
        if (d <= 0.0) {
            double iftmp$7;
            if (n != 0) {
                double iftmp$8 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                iftmp$7 = iftmp$8;
            } else {
                double iftmp$9 = n2 != 0 ? 0.0 : 1.0;
                iftmp$7 = iftmp$9;
            }
            d3 = iftmp$7;
        } else {
            double d4 = 1.0 / 0.0;
            if (d >= d4) {
                double iftmp$10;
                if (n != 0) {
                    double iftmp$11 = n2 != 0 ? 0.0 : 1.0;
                    iftmp$10 = iftmp$11;
                } else {
                    double iftmp$12 = n2 != 0 ? -1.0 / 0.0 : 0.0;
                    iftmp$10 = iftmp$12;
                }
                d3 = iftmp$10;
            } else {
                double res;
                if (d < 1.0) {
                    res = pgamma.pgamma_smallx(d, d2, n, n2);
                } else if (d2 - 1.0 >= d && (d2 + 50.0) * 0.8 > d) {
                    double sum2 = pgamma.pd_upper_series(d, d2, n2);
                    double d5 = pgamma.dpois_wrap(d2, d, n2);
                    if (n == 0) {
                        double iftmp$13;
                        if (n2 != 0) {
                            double iftmp$14 = d5 + sum2 > -0.6931471805599453 ? Math.log(-Mathlib.expm1(d5 + sum2)) : Mathlib.log1p(-Math.exp(d5 + sum2));
                            iftmp$13 = iftmp$14;
                        } else {
                            double d6 = d5 * sum2;
                            iftmp$13 = 1.0 - d6;
                        }
                        res = iftmp$13;
                    } else {
                        double iftmp$15 = n2 != 0 ? sum2 + d5 : sum2 * d5;
                        res = iftmp$15;
                    }
                } else if (d2 - 1.0 < d && (d + 50.0) * 0.8 > d2) {
                    double sum3;
                    double d7 = pgamma.dpois_wrap(d2, d, n2);
                    if (d2 < 1.0) {
                        double d8 = d * 2.220446049250313E-16;
                        double d9 = 1.0 - d2;
                        if (d8 > d9) {
                            double iftmp$16 = n2 != 0 ? 0.0 : 1.0;
                            sum3 = iftmp$16;
                        } else {
                            double d10 = d2 - 1.0;
                            double d11 = d - d10;
                            double f = pgamma.pd_lower_cf(d2, d11) * d / d2;
                            double iftmp$17 = n2 != 0 ? Math.log(f) : f;
                            sum3 = iftmp$17;
                        }
                    } else {
                        double d12 = d2 - 1.0;
                        sum3 = pgamma.pd_lower_series(d, d12);
                        double iftmp$18 = n2 != 0 ? Mathlib.log1p(sum3) : sum3 + 1.0;
                        sum3 = iftmp$18;
                    }
                    if (n == 0) {
                        double iftmp$19 = n2 != 0 ? sum3 + d7 : sum3 * d7;
                        res = iftmp$19;
                    } else {
                        double iftmp$20;
                        if (n2 != 0) {
                            double iftmp$21 = d7 + sum3 > -0.6931471805599453 ? Math.log(-Mathlib.expm1(d7 + sum3)) : Mathlib.log1p(-Math.exp(d7 + sum3));
                            iftmp$20 = iftmp$21;
                        } else {
                            double d13 = d7 * sum3;
                            iftmp$20 = 1.0 - d13;
                        }
                        res = iftmp$20;
                    }
                } else {
                    int n3 = n != 0 ? 0 : 1;
                    res = pgamma.ppois_asymp(d2 - 1.0, d, n3, n2);
                }
                d3 = n2 == 0 && res < 1.0020841800044864E-292 ? Math.exp(pgamma.Rf_pgamma_raw(d, d2, n, 1)) : res;
            }
        }
        return d3;
    }

    public static double ppois_asymp(double d, double d2, int n, int n2) {
        double d3;
        double res2_term;
        double res1_term;
        double s2pt = 0.0;
        double pt_ = 0.0;
        double res12 = 0.0;
        double dfm = d2 - d;
        pt_ = -pgamma.log1pmx(dfm / d);
        s2pt = Mathlib.sqrt(d * 2.0 * pt_);
        if (dfm < 0.0) {
            s2pt = -s2pt;
        }
        res12 = 0.0;
        double res1_ig = res1_term = Mathlib.sqrt(d);
        double res2_ig = res2_term = s2pt;
        int i = 1;
        while (i <= 7) {
            res12 = $ppois_asymp$coefs_a[0 + i] * res1_ig + res12;
            res12 = $ppois_asymp$coefs_b[0 + i] * res2_ig + res12;
            double d4 = i;
            res1_term = pt_ / d4 * res1_term;
            double d5 = pt_ * 2.0;
            double d6 = i * 2 + 1;
            res2_term = d5 / d6 * res2_term;
            res1_ig = res1_ig / d + res1_term;
            res2_ig = res2_ig / d + res2_term;
            ++i;
        }
        double elfb = d;
        double elfb_term = 1.0;
        i = 1;
        while (i <= 7) {
            elfb = $ppois_asymp$coefs_b[0 + i] * elfb_term + elfb;
            elfb_term /= d;
            ++i;
        }
        if (n == 0) {
            elfb = -elfb;
        }
        double f = res12 / elfb;
        int n3 = n != 0 ? 0 : 1;
        double np = pnorm.pnorm5(s2pt, 0.0, 1.0, n3, n2);
        if (n2 != 0) {
            int n4 = n != 0 ? 0 : 1;
            double n_d_over_p = pgamma.dpnorm(s2pt, n4, np);
            d3 = Mathlib.log1p(f * n_d_over_p) + np;
        } else {
            double nd = dnorm.dnorm4(s2pt, 0.0, 1.0, n2);
            d3 = f * nd + np;
        }
        return d3;
    }

    public static double dpnorm(double d, int n, double d2) {
        double d3;
        double x2 = 0.0;
        if (d < 0.0) {
            d = -d;
            int n2 = n = n != 0 ? 0 : 1;
        }
        if (d > 10.0 && n == 0) {
            double d4;
            double d5;
            double term;
            double sum2 = term = 1.0 / d;
            double d6 = d;
            x2 = d6 * d6;
            double i = 1.0;
            do {
                term = -i / x2 * term;
                i += 2.0;
            } while ((d5 = Math.abs(term)) > (d4 = (sum2 += term) * 2.220446049250313E-16));
            d3 = 1.0 / sum2;
        } else {
            double d7 = dnorm.dnorm4(d, 0.0, 1.0, 0);
            double d8 = Math.exp(d2);
            d3 = d7 / d8;
        }
        return d3;
    }

    public static double pd_lower_series(double d, double d2) {
        double term = 1.0;
        double sum2 = 0.0;
        while (d2 >= 1.0 && sum2 * 2.220446049250313E-16 < term) {
            term = d2 / d * term;
            sum2 += term;
            d2 -= 1.0;
        }
        if (Mathlib.floor(d2) != d2) {
            double d3 = d + 1.0 - d2;
            double f = pgamma.pd_lower_cf(d2, d3);
            sum2 = term * f + sum2;
        }
        return sum2;
    }

    public static double pd_lower_cf(double d, double d2) {
        double d3;
        block9: {
            double c4 = 0.0;
            double c2 = 0.0;
            double f0 = 0.0;
            double of = 0.0;
            double f = 0.0;
            f = 0.0;
            if (d == 0.0) {
                d3 = 0.0;
            } else {
                f0 = d / d2;
                double d4 = Math.abs(d - 1.0);
                double d5 = Math.abs(d2) * 2.220446049250313E-16;
                if (d4 < d5) {
                    d3 = f0;
                } else {
                    double scalefactor$26;
                    if (f0 > 1.0) {
                        f0 = 1.0;
                    }
                    c2 = d;
                    c4 = d2;
                    double a1 = 0.0;
                    double b1 = 1.0;
                    double a2 = d;
                    double b2 = d2;
                    while (b2 > (scalefactor$26 = scalefactor)) {
                        double scalefactor$22 = scalefactor;
                        a1 /= scalefactor$22;
                        double scalefactor$23 = scalefactor;
                        b1 /= scalefactor$23;
                        double scalefactor$24 = scalefactor;
                        a2 /= scalefactor$24;
                        double scalefactor$25 = scalefactor;
                        b2 /= scalefactor$25;
                    }
                    double i = 0.0;
                    of = -1.0;
                    while (i < 200000.0) {
                        double d6;
                        double d7;
                        double c3 = (i += 1.0) * (c2 -= 1.0);
                        double d8 = (c4 += 2.0) * a2;
                        double d9 = c3 * a1;
                        a1 = d8 + d9;
                        double d10 = c4 * b2;
                        double d11 = c3 * b1;
                        b1 = d10 + d11;
                        c3 = (i += 1.0) * (c2 -= 1.0);
                        double d12 = (c4 += 2.0) * a1;
                        double d13 = c3 * a2;
                        a2 = d12 + d13;
                        double d14 = c4 * b1;
                        double d15 = c3 * b2;
                        double scalefactor$27 = scalefactor;
                        if ((b2 = d14 + d15) > scalefactor$27) {
                            double scalefactor$28 = scalefactor;
                            a1 /= scalefactor$28;
                            double scalefactor$29 = scalefactor;
                            b1 /= scalefactor$29;
                            double scalefactor$30 = scalefactor;
                            a2 /= scalefactor$30;
                            double scalefactor$31 = scalefactor;
                            b2 /= scalefactor$31;
                        }
                        if (b2 == 0.0) continue;
                        f = a2 / b2;
                        double d16 = Math.abs(f - of);
                        if (d16 <= (d7 = fmax2.fmax2(f0, d6 = Math.abs(f)) * 2.220446049250313E-16)) {
                            d3 = f;
                            break block9;
                        }
                        of = f;
                    }
                    Stdlib.printf(new BytePtr(" ** NON-convergence in pgamma()'s pd_lower_cf() f= %g.\n\u0000".getBytes(), 0), f);
                    d3 = f;
                }
            }
        }
        return d3;
    }

    public static double pd_upper_series(double d, double d2, int n) {
        double term;
        double sum2 = term = d / d2;
        while ((sum2 += (term = d / (d2 += 1.0) * term)) * 2.220446049250313E-16 < term) {
        }
        double iftmp$32 = n != 0 ? Math.log(sum2) : sum2;
        return iftmp$32;
    }

    public static double pgamma_smallx(double d, double d2, int n, int n2) {
        double d3;
        double d4;
        double d5;
        double term;
        double d6;
        double sum2 = 0.0;
        double c2 = d2;
        double n3 = 0.0;
        while ((d6 = Math.abs(term = (c2 = -d / (n3 += 1.0) * c2) / (d5 = d2 + n3))) > (d4 = Math.abs(sum2 += term) * 2.220446049250313E-16)) {
        }
        if (n != 0) {
            double f2;
            double iftmp$33 = n2 != 0 ? Mathlib.log1p(sum2) : sum2 + 1.0;
            double f1 = iftmp$33;
            if (d2 > 1.0) {
                f2 = dpois.dpois_raw(d2, d, n2);
                double iftmp$34 = n2 != 0 ? f2 + d : Math.exp(d) * f2;
                f2 = iftmp$34;
            } else if (n2 != 0) {
                double d7 = Math.log(d) * d2;
                double d8 = pgamma.lgamma1p(d2);
                f2 = d7 - d8;
            } else {
                double d9 = Mathlib.pow(d, d2);
                double d10 = Math.exp(pgamma.lgamma1p(d2));
                f2 = d9 / d10;
            }
            double iftmp$35 = n2 != 0 ? f1 + f2 : f1 * f2;
            d3 = iftmp$35;
        } else {
            double d11 = Math.log(d) * d2;
            double d12 = pgamma.lgamma1p(d2);
            double lf2 = d11 - d12;
            if (n2 != 0) {
                double iftmp$36 = Mathlib.log1p(sum2) + lf2 > -0.6931471805599453 ? Math.log(-Mathlib.expm1(Mathlib.log1p(sum2) + lf2)) : Mathlib.log1p(-Math.exp(Mathlib.log1p(sum2) + lf2));
                d3 = iftmp$36;
            } else {
                double f1m1 = sum2;
                double f2m1 = Mathlib.expm1(lf2);
                double d13 = f1m1 + f2m1;
                double d14 = f1m1 * f2m1;
                d3 = -(d13 + d14);
            }
        }
        return d3;
    }

    public static double dpois_wrap(double d, double d2, int n) {
        double d3;
        if (Builtins.__finite(d2) == 0) {
            double iftmp$37 = n != 0 ? -1.0 / 0.0 : 0.0;
            d3 = iftmp$37;
        } else if (d > 1.0) {
            d3 = dpois.dpois_raw(d - 1.0, d2, n);
        } else {
            double d4 = Math.abs(d - 1.0);
            double M_cutoff$38 = M_cutoff;
            if (d4 * M_cutoff$38 < d2) {
                double iftmp$39;
                if (n != 0) {
                    double d5 = -d2;
                    double d6 = lgamma.lgammafn(d);
                    iftmp$39 = d5 - d6;
                } else {
                    double d7 = -d2;
                    double d8 = lgamma.lgammafn(d);
                    iftmp$39 = Math.exp(d7 - d8);
                }
                d3 = iftmp$39;
            } else {
                double d9 = dpois.dpois_raw(d, d2, n);
                double iftmp$40 = n != 0 ? Math.log(d / d2) + d9 : d / d2 * d9;
                d3 = iftmp$40;
            }
        }
        return d3;
    }

    public static double logspace_sum(DoublePtr doublePtr, int n) {
        double d;
        double[] logx$array = doublePtr.array;
        int logx$offset = doublePtr.offset;
        double Mx = 0.0;
        if (n == 0) {
            d = -1.0 / 0.0;
        } else if (n == 1) {
            d = logx$array[logx$offset];
        } else if (n == 2) {
            double[] dArray = logx$array;
            int n2 = logx$offset + 1;
            double d2 = dArray[n2];
            d = pgamma.logspace_add(logx$array[logx$offset], d2);
        } else {
            Mx = logx$array[logx$offset];
            int i = 1;
            while (i < n) {
                double[] dArray = logx$array;
                int n3 = i * 8;
                int n4 = logx$offset + n3 / 8;
                if (dArray[n4] > Mx) {
                    int n5 = i * 8;
                    double[] dArray2 = logx$array;
                    int n6 = logx$offset + n5 / 8;
                    Mx = dArray2[n6];
                }
                ++i;
            }
            double s = 0.0;
            i = 0;
            while (i < n) {
                int n7 = i * 8;
                double[] dArray = logx$array;
                int n8 = logx$offset + n7 / 8;
                s = Math.exp(dArray[n8] - Mx) + s;
                ++i;
            }
            d = Math.log(s) + Mx;
        }
        return d;
    }

    public static double logspace_sub(double d, double d2) {
        double iftmp$44 = d2 - d > -0.6931471805599453 ? Math.log(-Mathlib.expm1(d2 - d)) : Mathlib.log1p(-Math.exp(d2 - d));
        return iftmp$44 + d;
    }

    public static double logspace_add(double d, double d2) {
        double d3 = fmax2.fmax2(d, d2);
        double d4 = Mathlib.log1p(Math.exp(-Math.abs(d - d2)));
        return d3 + d4;
    }

    public static double lgamma1p(double d) {
        double d2;
        double eulers_const = 0.0;
        eulers_const = 0.5772156649015329;
        int N = 40;
        double c2 = 2.2737368458246524E-13;
        double tol_logcf = 1.0E-14;
        if (Math.abs(d) >= 0.5) {
            d2 = lgamma.lgammafn(d + 1.0);
        } else {
            double d3 = N + 2;
            double lgam = pgamma.logcf(-d / 2.0, d3, 1.0, tol_logcf) * c2;
            int i = N + -1;
            while (i >= 0) {
                double d4 = $lgamma1p$coeffs[0 + i];
                double d5 = d * lgam;
                lgam = d4 - d5;
                --i;
            }
            double d6 = (d * lgam - eulers_const) * d;
            double d7 = pgamma.log1pmx(d);
            d2 = d6 - d7;
        }
        return d2;
    }

    public static double log1pmx(double d) {
        double d2;
        double minLog1Value$45;
        if (d > 1.0 || d < (minLog1Value$45 = $log1pmx$minLog1Value)) {
            d2 = Mathlib.log1p(d) - d;
        } else {
            double r;
            double d3 = d + 2.0;
            double d4 = r = d / d3;
            double y = d4 * d4;
            if (Math.abs(d) < 0.01) {
                double d5 = $log1pmx$two / 9.0 * y;
                double d6 = $log1pmx$two / 7.0;
                double d7 = (d5 + d6) * y;
                double d8 = $log1pmx$two / 5.0;
                double d9 = (d7 + d8) * y;
                double d10 = $log1pmx$two / 3.0;
                d2 = ((d9 + d10) * y - d) * r;
            } else {
                double d11 = y * 2.0;
                double tol_logcf$50 = $log1pmx$tol_logcf;
                double d12 = pgamma.logcf(y, 3.0, 2.0, tol_logcf$50);
                d2 = (d11 * d12 - d) * r;
            }
        }
        return d2;
    }

    public static double logcf(double d, double d2, double d3, double d4) {
        double d5;
        double d6;
        double d7;
        double d8;
        double c1 = d3 * 2.0;
        double c2 = d2 + d3;
        double c4 = c2 + d3;
        double a1 = c2;
        double d9 = d2 * d;
        double b1 = (c2 - d9) * d2;
        double d10 = d3;
        double b2 = d10 * d10 * d;
        double a2 = c4 * c2 - b2;
        double d11 = c4 * b1;
        double d12 = d2 * b2;
        b2 = d11 - d12;
        while ((d8 = Math.abs((d7 = a2 * b1) - (d6 = a1 * b2))) > (d5 = Math.abs(d4 * b1 * b2))) {
            double scalefactor$51;
            double d13 = c2;
            double c3 = d13 * d13 * d;
            c2 += d3;
            double d14 = (c4 += d3) * a2;
            double d15 = c3 * a1;
            a1 = d14 - d15;
            double d16 = c4 * b2;
            double d17 = c3 * b1;
            b1 = d16 - d17;
            double d18 = c1;
            c3 = d18 * d18 * d;
            c1 += d3;
            double d19 = (c4 += d3) * a1;
            double d20 = c3 * a2;
            a2 = d19 - d20;
            double d21 = c4 * b1;
            double d22 = c3 * b2;
            double d23 = Math.abs(b2 = d21 - d22);
            if (d23 > (scalefactor$51 = scalefactor)) {
                double scalefactor$52 = scalefactor;
                a1 /= scalefactor$52;
                double scalefactor$53 = scalefactor;
                b1 /= scalefactor$53;
                double scalefactor$54 = scalefactor;
                a2 /= scalefactor$54;
                double scalefactor$55 = scalefactor;
                b2 /= scalefactor$55;
                continue;
            }
            double d24 = Math.abs(b2);
            double scalefactor$56 = scalefactor;
            double d25 = 1.0 / scalefactor$56;
            if (!(d24 < d25)) continue;
            double scalefactor$57 = scalefactor;
            a1 *= scalefactor$57;
            double scalefactor$58 = scalefactor;
            b1 *= scalefactor$58;
            double scalefactor$59 = scalefactor;
            a2 *= scalefactor$59;
            double scalefactor$60 = scalefactor;
            b2 *= scalefactor$60;
        }
        return a2 / b2;
    }

    static {
        $ppois_asymp$coefs_b = new double[8];
        $ppois_asymp$coefs_a = new double[8];
        $lgamma1p$coeffs = new double[40];
        M_cutoff = 3.196577161300664E18;
        scalefactor = 1.157920892373162E77;
        System.arraycopy(new double[]{-1.0E99, 0.08333333333333333, 0.003472222222222222, -0.0026813271604938273, -2.2947209362139917E-4, 7.840392217200666E-4, 6.972813758365857E-5, -5.921664373536939E-4}, 0, $ppois_asymp$coefs_b, 0, 8);
        System.arraycopy(new double[]{-1.0E99, 0.6666666666666666, -0.02962962962962963, 0.0028218694885361554, 0.0018812463256907702, -7.119598889146215E-4, -6.783725850941215E-4, 4.728641948577934E-4}, 0, $ppois_asymp$coefs_a, 0, 8);
        System.arraycopy(new double[]{0.3224670334241132, 0.0673523010531981, 0.020580808427784546, 0.007385551028673986, 0.0028905103307415234, 0.001192753911703261, 5.096695247430425E-4, 2.2315475845357939E-4, 9.945751278180853E-5, 4.492623673813314E-5, 2.050721277567069E-5, 9.439488275268397E-6, 4.374866789907488E-6, 2.039215753801366E-6, 9.55141213040742E-7, 4.492469198764566E-7, 2.1207184805554665E-7, 1.0043224823968099E-7, 4.7698101693639804E-8, 2.2711094608943164E-8, 1.0838659214896955E-8, 5.183475041970047E-9, 2.4836745438024785E-9, 1.1921401405860912E-9, 5.731367241678862E-10, 2.7595228851242334E-10, 1.330476437424449E-10, 6.4229645638381E-11, 3.1044247747322276E-11, 1.5021384080754142E-11, 7.275974480239079E-12, 3.527742476575915E-12, 1.711991790559618E-12, 8.315385841420285E-13, 4.04220052528944E-13, 1.9664756310966165E-13, 9.573630387838556E-14, 4.6640760264283744E-14, 2.2737369600659724E-14, 1.1091399470834522E-14}, 0, $lgamma1p$coeffs, 0, 40);
        $log1pmx$tol_logcf = 1.0E-14;
        $log1pmx$two = 2.0;
        $log1pmx$minLog1Value = -0.79149064;
    }
}

