/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.nmath;

import java.lang.invoke.MethodHandle;
import org.renjin.gcc.runtime.Builtins;
import org.renjin.nmath.rgamma;
import org.renjin.nmath.rpois;

public class rnbinom {
    private rnbinom() {
    }

    public static double rnbinom_mu(MethodHandle methodHandle, double d, double d2) {
        double d3;
        if (Builtins.__finite(d2) == 0 || d <= 0.0 || d2 < 0.0) {
            d3 = 0.0 / 0.0;
        } else {
            double iftmp$0;
            if (Builtins.__finite(d) == 0) {
                d = 8.988465674311579E307;
            }
            if (d2 != 0.0) {
                double d4 = d2 / d;
                double d5 = rgamma.rgamma(methodHandle, d, d4);
                iftmp$0 = rpois.rpois(methodHandle, d5);
            } else {
                iftmp$0 = 0.0;
            }
            d3 = iftmp$0;
        }
        return d3;
    }

    public static double rnbinom(MethodHandle methodHandle, double d, double d2) {
        double d3;
        if (Builtins.__finite(d2) == 0 || d <= 0.0 || d2 <= 0.0 || d2 > 1.0) {
            d3 = 0.0 / 0.0;
        } else {
            double iftmp$1;
            if (Builtins.__finite(d) == 0) {
                d = 8.988465674311579E307;
            }
            if (d2 != 1.0) {
                double d4 = (1.0 - d2) / d2;
                double d5 = rgamma.rgamma(methodHandle, d, d4);
                iftmp$1 = rpois.rpois(methodHandle, d5);
            } else {
                iftmp$1 = 0.0;
            }
            d3 = iftmp$1;
        }
        return d3;
    }
}

