/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives;

import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.eval.Options;
import org.renjin.invoke.annotations.AllowNull;
import org.renjin.invoke.annotations.ArgumentList;
import org.renjin.invoke.annotations.Builtin;
import org.renjin.invoke.annotations.Current;
import org.renjin.invoke.annotations.DataParallel;
import org.renjin.invoke.annotations.Deferrable;
import org.renjin.invoke.annotations.Generic;
import org.renjin.invoke.annotations.Internal;
import org.renjin.invoke.annotations.Recycle;
import org.renjin.primitives.vector.IsNaVector;
import org.renjin.repackaged.guava.base.Strings;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Closure;
import org.renjin.sexp.ComplexVector;
import org.renjin.sexp.DoubleVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.ExpressionVector;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntVector;
import org.renjin.sexp.ListVector;
import org.renjin.sexp.Logical;
import org.renjin.sexp.LogicalArrayVector;
import org.renjin.sexp.LogicalVector;
import org.renjin.sexp.NamedValue;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.PrimitiveFunction;
import org.renjin.sexp.RawVector;
import org.renjin.sexp.Recursive;
import org.renjin.sexp.S4Object;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Symbols;

public class Types {
    @Builtin(value="is.null")
    public static boolean isNull(SEXP exp2) {
        return exp2 == Null.INSTANCE;
    }

    @Builtin(value="is.logical")
    public static boolean isLogical(SEXP exp2) {
        return exp2 instanceof LogicalVector;
    }

    @Builtin(value="is.integer")
    public static boolean isInteger(SEXP exp2) {
        return exp2 instanceof IntVector;
    }

    @Builtin(value="is.real")
    public static boolean isReal(SEXP exp2) {
        return exp2 instanceof DoubleVector;
    }

    @Builtin(value="is.double")
    public static boolean isDouble(SEXP exp2) {
        return exp2 instanceof DoubleVector;
    }

    @Builtin(value="is.complex")
    public static boolean isComplex(SEXP exp2) {
        return exp2 instanceof ComplexVector;
    }

    @Builtin(value="is.character")
    public static boolean isCharacter(SEXP exp2) {
        return exp2 instanceof StringVector;
    }

    @Builtin(value="is.symbol")
    public static boolean isSymbol(SEXP exp2) {
        return exp2 instanceof Symbol;
    }

    @Builtin(value="is.environment")
    public static boolean isEnvironment(SEXP exp2) {
        return exp2 instanceof Environment;
    }

    @Builtin(value="is.expression")
    public static boolean isExpression(SEXP exp2) {
        return exp2 instanceof Environment;
    }

    @Builtin(value="is.list")
    public static boolean isList(SEXP exp2) {
        return exp2 instanceof ListVector || exp2.getClass() == PairList.Node.class;
    }

    @Builtin(value="is.pairlist")
    public static boolean isPairList(SEXP exp2) {
        return exp2 instanceof PairList && !(exp2 instanceof FunctionCall);
    }

    @Builtin(value="is.atomic")
    public static boolean isAtomic(SEXP exp2) {
        return exp2 instanceof AtomicVector;
    }

    @Builtin(value="is.recursive")
    public static boolean isRecursive(SEXP exp2) {
        return exp2 instanceof Recursive;
    }

    @Generic
    @Builtin(value="is.numeric")
    public static boolean isNumeric(SEXP exp2) {
        return exp2 instanceof IntVector && !exp2.inherits("factor") || exp2 instanceof DoubleVector;
    }

    @Generic
    @Builtin(value="is.matrix")
    public static boolean isMatrix(SEXP exp2) {
        return exp2.getAttribute(Symbols.DIM).length() == 2;
    }

    @Generic
    @Builtin(value="is.array")
    public static boolean isArray(SEXP exp2) {
        return exp2.getAttribute(Symbols.DIM).length() > 0;
    }

    @Internal(value="is.vector")
    public static boolean isVector(SEXP exp2, String mode) {
        if (exp2.getAttributes().hasAnyBesidesName()) {
            return false;
        }
        if ("logical".equals(mode)) {
            return exp2 instanceof LogicalVector;
        }
        if ("integer".equals(mode)) {
            return exp2 instanceof IntVector;
        }
        if ("numeric".equals(mode)) {
            return exp2 instanceof IntVector || exp2 instanceof DoubleVector;
        }
        if ("double".equals(mode)) {
            return exp2 instanceof DoubleVector;
        }
        if ("complex".equals(mode)) {
            return exp2 instanceof ComplexVector;
        }
        if ("character".equals(mode)) {
            return exp2 instanceof StringVector;
        }
        if ("any".equals(mode)) {
            return exp2 != Null.INSTANCE && (exp2 instanceof AtomicVector || exp2 instanceof ListVector);
        }
        if ("list".equals(mode)) {
            return exp2 instanceof ListVector;
        }
        return false;
    }

    @Builtin(value="is.object")
    public static boolean isObject(SEXP exp2) {
        return exp2.isObject();
    }

    @Builtin(value="is.call")
    public static boolean isCall(SEXP exp2) {
        return exp2 instanceof FunctionCall;
    }

    @Builtin(value="is.language")
    public static boolean isLanguage(SEXP exp2) {
        return exp2 instanceof Symbol || exp2 instanceof FunctionCall || exp2 instanceof ExpressionVector;
    }

    @Builtin(value="is.function")
    public static boolean isFunction(SEXP exp2) {
        return exp2 instanceof Function;
    }

    @Builtin(value="is.single")
    public static boolean isSingle(SEXP exp2) {
        throw new EvalException("type \"single\" unimplemented in R", new Object[0]);
    }

    @Generic
    @Builtin(value="is.na")
    public static LogicalVector isNA(ListVector vector2) {
        return Types.isListNA(vector2);
    }

    @Generic
    @Builtin(value="is.na")
    public static LogicalVector isNA(PairList.Node pairlist2) {
        return Types.isListNA(pairlist2);
    }

    @Generic
    @Builtin(value="is.na")
    public static LogicalVector isNA(Symbol symbol2) {
        return LogicalVector.FALSE;
    }

    private static LogicalVector isListNA(SEXP list2) {
        LogicalArrayVector.Builder result = new LogicalArrayVector.Builder(list2.length());
        for (int i = 0; i != list2.length(); ++i) {
            Object element = list2.getElementAsSEXP(i);
            if (element instanceof AtomicVector && element.length() == 1) {
                result.set(i, ((AtomicVector)element).isElementNaN(0));
                continue;
            }
            result.set(i, false);
        }
        result.setAttribute(Symbols.DIM, list2.getAttribute(Symbols.DIM));
        result.setAttribute(Symbols.NAMES, list2.getAttribute(Symbols.NAMES));
        result.setAttribute(Symbols.DIMNAMES, list2.getAttribute(Symbols.DIMNAMES));
        return result.build();
    }

    @Generic
    @Builtin(value="is.na")
    public static LogicalVector isNA(AtomicVector vector2) {
        if (vector2.length() > 100 || vector2.isDeferred()) {
            return new IsNaVector(vector2);
        }
        LogicalArrayVector.Builder result = new LogicalArrayVector.Builder(vector2.length());
        for (int i = 0; i != vector2.length(); ++i) {
            result.set(i, vector2.isElementNaN(i));
        }
        result.setAttribute(Symbols.DIM, vector2.getAttribute(Symbols.DIM));
        result.setAttribute(Symbols.NAMES, vector2.getAttribute(Symbols.NAMES));
        result.setAttribute(Symbols.DIMNAMES, vector2.getAttribute(Symbols.DIMNAMES));
        return result.build();
    }

    @Generic
    @Builtin(value="is.nan")
    @DataParallel(passNA=true)
    @Deferrable
    public static boolean isNaN(@AllowNull double value) {
        return !DoubleVector.isNA(value) && DoubleVector.isNaN(value);
    }

    @Generic
    @Builtin(value="is.nan")
    @DataParallel(passNA=true)
    @Deferrable
    public static boolean isNaN(String value) {
        return false;
    }

    @Generic
    @Builtin(value="is.finite")
    @DataParallel(passNA=true)
    @Deferrable
    public static boolean isFinite(@AllowNull @Recycle double value) {
        return !Double.isNaN(value) && !Double.isInfinite(value);
    }

    @Generic
    @Builtin(value="is.finite")
    @DataParallel(passNA=true)
    @Deferrable
    public static boolean isFinite(@Recycle String value) {
        return false;
    }

    @Generic
    @Builtin(value="is.infinite")
    @DataParallel(passNA=true)
    @Deferrable
    public static boolean isInfinite(@AllowNull @Recycle double value) {
        return Double.isInfinite(value);
    }

    @Generic
    @Builtin(value="is.infinite")
    @DataParallel(passNA=true)
    @Deferrable
    public static boolean isInfinite(@Recycle String value) {
        return false;
    }

    @Builtin
    public static boolean isS4(SEXP object2) {
        if (object2 instanceof S4Object) {
            return true;
        }
        SEXP bit = object2.getAttribute(Symbols.S4_BIT);
        return bit instanceof LogicalVector && bit.length() == 1 && ((LogicalVector)bit).getElementAsLogical(0) == Logical.TRUE;
    }

    @Internal
    public static SEXP setS4Object(SEXP object2, boolean bool, boolean complete2) {
        if (object2 instanceof S4Object) {
            return object2;
        }
        return object2.setAttribute(Symbols.S4_BIT, (SEXP)LogicalVector.TRUE);
    }

    @Internal(value="as.function.default")
    public static Closure asFunctionDefault(ListVector list2, Environment envir) {
        PairList.Builder formals2 = new PairList.Builder();
        int i = 0;
        while (i + 1 < list2.length()) {
            String name = list2.getName(i);
            if (Strings.isNullOrEmpty(name)) {
                throw new EvalException("formal arguments to a closure must be named", new Object[0]);
            }
            formals2.add(name, list2.getElementAsSEXP(i));
            ++i;
        }
        SEXP body2 = list2.getElementAsSEXP(list2.length() - 1);
        return new Closure(envir, formals2.build(), body2);
    }

    @Builtin(value="is.raw")
    public static boolean isRaw(SEXP sexp2) {
        return sexp2 instanceof RawVector;
    }

    @Builtin(value="as.call")
    public static FunctionCall asCall(ListVector list2) {
        EvalException.check(list2.length() > 0, "invalid length 0 argument", new Object[0]);
        PairList.Builder arguments = new PairList.Builder();
        for (int i = 1; i != list2.length(); ++i) {
            arguments.add(list2.getName(i), list2.getElementAsSEXP(i));
        }
        return new FunctionCall(list2.getElementAsSEXP(0), arguments.build());
    }

    @Builtin(value="as.call")
    public static FunctionCall asCall(FunctionCall call2) {
        return call2;
    }

    @Builtin
    public static ListVector list(@ArgumentList ListVector arguments) {
        return arguments;
    }

    @Internal
    public static PairList formals(Closure closure) {
        return closure.getFormals();
    }

    @Internal
    public static Null formals(PrimitiveFunction function2) {
        return Null.INSTANCE;
    }

    @Internal
    public static SEXP body(Closure closure) {
        return closure.getBody();
    }

    @Internal
    public static String typeof(SEXP exp2) {
        return exp2.getTypeName();
    }

    @Builtin
    public static SEXP invisible(@Current Context context, SEXP value) {
        context.setInvisibleFlag();
        return value;
    }

    @Builtin
    public static SEXP invisible(@Current Context context) {
        context.setInvisibleFlag();
        return Null.INSTANCE;
    }

    @Internal
    public static String Encoding(StringVector vector2) {
        return "UTF-8";
    }

    @Internal
    public static StringVector setEncoding(StringVector vector2, String encodingName) {
        if (encodingName.equals("UTF-8") || encodingName.equals("unknown")) {
            return vector2;
        }
        throw new EvalException("Only UTF-8 and unknown encoding are supported at this point", new Object[0]);
    }

    @Builtin
    public static boolean isFactor(SEXP exp2) {
        return exp2 instanceof IntVector && exp2.inherits("factor");
    }

    private static boolean isListFactor(ListVector list2) {
        for (SEXP element : list2) {
            if (element instanceof ListVector && !Types.isListFactor((ListVector)element)) {
                return false;
            }
            if (Types.isFactor(element)) continue;
            return false;
        }
        return true;
    }

    @Internal
    public static boolean islistfactor(SEXP exp2, boolean recursive2) {
        if (!(exp2 instanceof ListVector)) {
            return false;
        }
        if (exp2.length() == 0) {
            return false;
        }
        ListVector vector2 = (ListVector)exp2;
        for (SEXP element : vector2) {
            if (!(element instanceof ListVector ? !recursive2 || !Types.isListFactor((ListVector)element) : !Types.isFactor(exp2))) continue;
            return false;
        }
        return true;
    }

    @Internal
    public static ListVector options(@Current Context context, @ArgumentList ListVector arguments) {
        Options options2 = context.getSession().getSingleton(Options.class);
        ListVector.NamedBuilder results = ListVector.newNamedBuilder();
        if (arguments.length() == 0) {
            for (String name : options2.names()) {
                results.add(name, options2.get(name));
            }
        } else if (arguments.length() == 1 && arguments.getElementAsSEXP(0) instanceof ListVector && StringVector.isNA(arguments.getName(0))) {
            ListVector list2 = (ListVector)arguments.getElementAsSEXP(0);
            if (list2.getAttribute(Symbols.NAMES) == Null.INSTANCE) {
                throw new EvalException("list argument has no valid names", new Object[0]);
            }
            for (NamedValue argument : list2.namedValues()) {
                if (!argument.hasName()) {
                    throw new EvalException("invalid argument", new Object[0]);
                }
                String name = argument.getName();
                results.add(name, options2.set(name, argument.getValue()));
            }
        } else {
            for (NamedValue argument : arguments.namedValues()) {
                String name;
                if (argument.hasName()) {
                    name = argument.getName();
                    results.add(name, options2.set(name, argument.getValue()));
                    continue;
                }
                if (argument.getValue() instanceof StringVector) {
                    name = ((StringVector)argument.getValue()).getElementAsString(0);
                    results.add(name, options2.get(name));
                    continue;
                }
                throw new EvalException("invalid argument", new Object[0]);
            }
            context.setInvisibleFlag();
        }
        return results.build();
    }
}

