/*
 * Decompiled with CFR 0.152.
 */
package org.renjin.primitives.combine;

import java.util.ArrayList;
import java.util.List;
import org.renjin.eval.Context;
import org.renjin.eval.EvalException;
import org.renjin.invoke.codegen.ArgumentIterator;
import org.renjin.primitives.combine.BindArgument;
import org.renjin.primitives.combine.Inspector;
import org.renjin.primitives.combine.MatrixDim;
import org.renjin.repackaged.guava.collect.Lists;
import org.renjin.sexp.AtomicVector;
import org.renjin.sexp.Environment;
import org.renjin.sexp.Function;
import org.renjin.sexp.FunctionCall;
import org.renjin.sexp.IntArrayVector;
import org.renjin.sexp.Null;
import org.renjin.sexp.PairList;
import org.renjin.sexp.Promise;
import org.renjin.sexp.SEXP;
import org.renjin.sexp.SpecialFunction;
import org.renjin.sexp.StringVector;
import org.renjin.sexp.Symbol;
import org.renjin.sexp.Vector;

public abstract class AbstractBindFunction
extends SpecialFunction {
    private MatrixDim bindDim;

    protected AbstractBindFunction(String name, MatrixDim bindDim) {
        super(name);
        this.bindDim = bindDim;
    }

    @Override
    public final SEXP apply(Context context, Environment rho, FunctionCall call2, PairList arguments) {
        ArgumentIterator argumentItr = new ArgumentIterator(context, rho, arguments);
        int deparseLevel = ((Vector)argumentItr.evalNext()).getElementAsInt(0);
        ArrayList<BindArgument> bindArguments = Lists.newArrayList();
        while (argumentItr.hasNext()) {
            PairList.Node currentNode = argumentItr.nextNode();
            SEXP evaluated = context.evaluate(currentNode.getValue(), rho);
            bindArguments.add(new BindArgument(currentNode.getName(), (Vector)evaluated, this.bindDim, currentNode.getValue(), deparseLevel, context));
        }
        SEXP genericResult = AbstractBindFunction.tryBindDispatch(context, rho, this.getName(), deparseLevel, bindArguments);
        if (genericResult != null) {
            return genericResult;
        }
        if (this.onlyNullArguments(bindArguments)) {
            return Null.INSTANCE;
        }
        return this.apply(context, bindArguments);
    }

    protected abstract SEXP apply(Context var1, List<BindArgument> var2);

    protected static boolean allZeroLengthVectors(List<BindArgument> bindArguments) {
        for (BindArgument bindArgument : bindArguments) {
            if (bindArgument.isZeroLengthVector()) continue;
            return false;
        }
        return true;
    }

    public static SEXP tryBindDispatch(Context context, Environment rho, String bindFunctionName, int deparseLevel, List<BindArgument> arguments) {
        Symbol foundMethod = null;
        Function foundFunction = null;
        for (BindArgument argument : arguments) {
            Vector classes = argument.getClasses();
            for (int i = 0; i != classes.length(); ++i) {
                Symbol methodName = Symbol.get(bindFunctionName + "." + classes.getElementAsString(i));
                Function function2 = rho.findFunction(context, methodName);
                if (function2 == null) continue;
                if (foundMethod != null && methodName != foundMethod) {
                    return null;
                }
                foundMethod = methodName;
                foundFunction = function2;
            }
        }
        if (foundFunction == null) {
            return null;
        }
        PairList.Builder args2 = new PairList.Builder();
        args2.add("deparse.level", (SEXP)new Promise(Symbol.get("deparse.level"), (SEXP)new IntArrayVector(deparseLevel)));
        for (BindArgument argument : arguments) {
            args2.add(argument.getArgName(), (SEXP)argument.repromise());
        }
        PairList buildArgs = args2.build();
        FunctionCall call2 = new FunctionCall(Symbol.get(bindFunctionName), buildArgs);
        return foundFunction.apply(context, rho, call2, buildArgs);
    }

    private boolean onlyNullArguments(List<BindArgument> bindArguments) {
        for (BindArgument bindArgument : bindArguments) {
            if (bindArgument.isNull()) continue;
            return false;
        }
        return true;
    }

    protected int findCommonMatrixDimLength(List<BindArgument> bindArguments, MatrixDim dim2) {
        int length2 = -1;
        for (BindArgument argument : bindArguments) {
            if (!argument.isMatrix()) continue;
            if (length2 == -1) {
                length2 = argument.getDimLength(dim2);
                continue;
            }
            if (length2 == argument.getDimLength(dim2)) continue;
            throw new EvalException("number of %s of matrices must match", dim2.name().toLowerCase() + "s");
        }
        return length2;
    }

    protected static int findMaxLength(List<BindArgument> bindArguments) {
        int length2 = 0;
        for (BindArgument argument : bindArguments) {
            if (argument.getVector().length() <= length2) continue;
            length2 = argument.getVector().length();
        }
        return length2;
    }

    protected void warnIfVectorLengthsAreNotMultiple(Context context, List<BindArgument> bindArguments, int expectedLength) {
        for (BindArgument argument : bindArguments) {
            if (argument.isMatrix() || argument.isZeroLength() || expectedLength % argument.getVector().length() == 0) continue;
            context.warn("number of " + (this.bindDim == MatrixDim.COL ? "rows" : "cols") + " of result is not a multiple of vector length");
        }
    }

    protected Vector.Builder builderForCommonType(List<BindArgument> bindArguments) {
        Inspector inspector = new Inspector(false);
        for (BindArgument bindArgument : bindArguments) {
            if (bindArgument.getVector() == Null.INSTANCE) continue;
            bindArgument.getVector().accept(inspector);
        }
        return inspector.getResult().newBuilder();
    }

    protected List<BindArgument> excludeZeroLengthVectors(List<BindArgument> bindArguments) {
        ArrayList<BindArgument> retained = new ArrayList<BindArgument>(bindArguments.size());
        for (BindArgument bindArgument : bindArguments) {
            if (bindArgument.isZeroLengthVector()) continue;
            retained.add(bindArgument);
        }
        return retained;
    }

    protected int countRowOrCols(List<BindArgument> bindArguments, MatrixDim dim2) {
        int count = 0;
        for (BindArgument bindArgument : bindArguments) {
            count += bindArgument.getDimLength(dim2);
        }
        return count;
    }

    protected AtomicVector combineDimNames(List<BindArgument> bindArguments, MatrixDim dim2) {
        boolean hasNames = false;
        StringVector.Builder resultNames = new StringVector.Builder();
        for (BindArgument argument : bindArguments) {
            int i;
            AtomicVector argumentNames = argument.getNames(dim2);
            if (argumentNames != Null.INSTANCE) {
                hasNames = true;
                for (i = 0; i != argumentNames.length(); ++i) {
                    resultNames.add(argumentNames.getElementAsString(i));
                }
                continue;
            }
            if (!argument.hasNoName() && !argument.isMatrix()) {
                resultNames.add(argument.getName());
                hasNames = true;
                continue;
            }
            for (i = 0; i != argument.getDimLength(dim2); ++i) {
                resultNames.add("");
            }
        }
        if (hasNames) {
            return resultNames.build();
        }
        return Null.INSTANCE;
    }

    protected AtomicVector dimNamesFromLongest(List<BindArgument> bindArguments, MatrixDim dim2, int dimLength) {
        for (BindArgument argument : bindArguments) {
            AtomicVector argumentNames;
            if (argument.getDimLength(dim2) != dimLength || (argumentNames = argument.getNames(dim2)) == Null.INSTANCE) continue;
            return argumentNames;
        }
        return Null.INSTANCE;
    }
}

